#ifndef MARS_MCT1PointingCorrCalc
#define MARS_MCT1PointingCorrCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1PointingCorrCalc                                                    //
//                                                                         //
// Task to do the pointing correction                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MSrcPosCam;
class MParameterD;


class MCT1PointingCorrCalc : public MTask
{
private:

    MSrcPosCam   *fSrcPos;
    TString       fSrcName;
    MParameterD  *fHourAngle;

    Float_t       fMm2Deg;

public:
    MCT1PointingCorrCalc(const char *srcname="MSrcPosCam",
                         const char *name=NULL, const char *title=NULL);

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    ClassDef(MCT1PointingCorrCalc, 0)   // Task to do the CT1 pointing correction for Mkn421 2001 data
};

#endif











