/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */
#include "MCerPhotPix.h"

#include "MLog.h"

ClassImp(MCerPhotPix);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. The pixel is assumed as used and not a core pixel.
// NT 29/04/2003: A pixel is considered used when fRing > 0.
//
MCerPhotPix::MCerPhotPix(Int_t pix, Float_t phot, Float_t errphot) :
    fPixId(pix), fRing(1), fIsCore(kFALSE), fPhot(phot), fErrPhot(errphot)
{
} 

// --------------------------------------------------------------------------
//
//  Print information to gLog.
//
void MCerPhotPix::Print(Option_t *) const
{ 
    gLog << GetDescriptor() <<" Pixel: "<< fPixId;
    gLog << (fRing>0?"   Used ":" Unused ");
    gLog << (fIsCore?" Core ":"      ");
    gLog << "Nphot= " << fPhot << " Error(Nphot)=" << fErrPhot << endl;
}
