#ifndef MARS_MCerPhotPix_H
#define MARS_MCerPhotPix_H

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCerPhotPix : public MParContainer
{
private:

    Int_t    fPixId;     // the pixel Id

    UShort_t fRing;      // NT: number of analyzed rings around the core pixels (fRing>0 means: used)
    Bool_t   fIsCore;    // the pixel is a Core pixel -> kTRUE

    Float_t  fPhot;      // The number of Cerenkov photons
    Float_t  fErrPhot;   // the error of fPhot

    // FIXME: arrival time t, and it's error sigma t

public:
    MCerPhotPix(Int_t pix=-1, Float_t phot=0, Float_t errphot=0);

    Int_t    GetPixId() const            { return fPixId;   }
    Float_t  GetNumPhotons() const       { return fPhot;    }
    Float_t  GetErrorPhot() const        { return fErrPhot; }

    Bool_t   IsPixelUsed() const         { return fRing>0; }
    void     SetPixelUnused()            { fRing=0; }
    void     SetPixelUsed()              { fRing=1; }

    void     SetRing(UShort_t r)         { fRing = r;   }
    Short_t  GetRing() const             { return fRing;}

    void     SetPixelCore()              { fIsCore = kTRUE; }
    Bool_t   IsPixelCore() const         { return fIsCore;  }

    void     SetNumPhotons(Float_t f)    { fPhot    = f; }
    void     SetErrorPhot(Float_t f)     { fErrPhot = f; }
    void     Set(Float_t np, Float_t ep) { fPhot = np; fErrPhot = ep; }

    void     AddNumPhotons(Float_t f)    { fPhot += f; }

    void     Scale(Float_t f)            { fPhot/=f; }

    void     Print(Option_t *opt = NULL) const;

    ClassDef(MCerPhotPix, 1)  // class containing information about the Cerenkov Photons in a pixel
};

#endif


