/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Oscar Blanch 07/2003 <mailto:blanch@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MGeomCamMagic919
//
// This class stores the geometry information of Magic camera,
// which only has small pixels.
// All information are copied from tables, see source code.
//
////////////////////////////////////////////////////////////////////////////
#include "MGeomCamMagic919.h"

/*
 #include "MLog.h"
 #include "MLogManip.h"
 */

#include "MGeomPix.h"

ClassImp(MGeomCamMagic919);

// --------------------------------------------------------------------------
//
//  This Magic camera has 919 pixels. For geometry and Next Neighbor info see
//  CreateCam and CreateNN
//
MGeomCamMagic919::MGeomCamMagic919(const char *name)
    : MGeomCam(919, 17, name, 
	       "Geometry information of Magic Camera with only small pixels")
{
    CreateCam();
    CreateNN();
    CalcMaxRadius();
}

// --------------------------------------------------------------------------
//
//  This fills the geometry information from a table into the pixel objects.
//
void MGeomCamMagic919::CreateCam()
{
    //
    //   fill the geometry class with the coordinates of the MAGIC camera
    //
    //*fLog << inf << " Creating Magic geometry " << endl ;

    //
    //   here define the hardwire things of the magic telescope
    //

  const float xtemp[919] = {
	0, 30, 15, -15, -30, -15, 15, 60, // 0
	45, 30, 0, -30, -45, -60, -45, -30, // 8
	0, 30, 45, 90, 75, 60, 45, 15, // 16
	-15, -45, -60, -75, -90, -75, -60, -45, // 24
	-15, 15, 45, 60, 75, 120, 105, 90, // 32
	75, 60, 30, 0, -30, -60, -75, -90, // 40
	-105, -120, -105, -90, -75, -60, -30, 0, // 48
	30, 60, 75, 90, 105, 150, 135, 120, // 56
	105, 90, 75, 45, 15, -15, -45, -75, // 64
	-90, -105, -120, -135, -150, -135, -120, -105, // 72
	-90, -75, -45, -15, 15, 45, 75, 90, // 80
	105, 120, 135, 180, 165, 150, 135, 120, // 88
	105, 90, 60, 30, 0, -30, -60, -90, // 96
	-105, -120, -135, -150, -165, -180, -165, -150, // 104
	-135, -120, -105, -90, -60, -30, 0, 30, // 112
	60, 90, 105, 120, 135, 150, 165, 210, // 120
	195, 180, 165, 150, 135, 120, 105, 75, // 128
	45, 15, -15, -45, -75, -105, -120, -135, // 136
	-150, -165, -180, -195, -210, -195, -180, -165, // 144
	-150, -135, -120, -105, -75, -45, -15, 15, // 152
	45, 75, 105, 120, 135, 150, 165, 180, // 160
	195, 240, 225, 210, 195, 180, 165, 150, // 168
	135, 120, 90, 60, 30, 0, -30, -60, // 176
	-90, -120, -135, -150, -165, -180, -195, -210, // 184
	-225, -240, -225, -210, -195, -180, -165, -150, // 192
	-135, -120, -90, -60, -30, 0, 30, 60, // 200
	90, 120, 135, 150, 165, 180, 195, 210, // 208
	225, 270, 255, 240, 225, 210, 195, 180, // 216
	165, 150, 135, 105, 75, 45, 15, -15, // 224
	-45, -75, -105, -135, -150, -165, -180, -195, // 232
	-210, -225, -240, -255, -270, -255, -240, -225, // 240
	-210, -195, -180, -165, -150, -135, -105, -75, // 248
	-45, -15, 15, 45, 75, 105, 135, 150, // 256
	165, 180, 195, 210, 225, 240, 255, 300, // 264
	285, 270, 255, 240, 225, 210, 195, 180, // 272
	165, 150, 120, 90, 60, 30, 0, -30, // 280
	-60, -90, -120, -150, -165, -180, -195, -210, // 288
	-225, -240, -255, -270, -285, -300, -285, -270, // 296
	-255, -240, -225, -210, -195, -180, -165, -150, // 304
	-120, -90, -60, -30, 0, 30, 60, 90, // 312
	120, 150, 165, 180, 195, 210, 225, 240, // 320
	255, 270, 285, 330, 315, 300, 285, 270, // 328
	255, 240, 225, 210, 195, 180, 165, 135, // 336
	105, 75, 45, 15, -15, -45, -75, -105, // 344
	-135, -165, -180, -195, -210, -225, -240, -255, // 352
	-270, -285, -300, -315, -330, -315, -300, -285, // 360
	-270, -255, -240, -225, -210, -195, -180, -165, // 368
	-135, -105, -75, -45, -15, 15, 45, 75, // 376
	105, 135, 165, 180, 195, 210, 225, 240, // 384
	255, 270, 285, 300, 315, 360, 345, 330, // 392
	315, 300, 285, 270, 255, 240, 225, 210, // 400
	195, 180, 150, 120, 90, 60, 30, 0, // 408
	-30, -60, -90, -120, -150, -180, -195, -210, // 416
	-225, -240, -255, -270, -285, -300, -315, -330, // 424
	-345, -360, -345, -330, -315, -300, -285, -270, // 432
	-255, -240, -225, -210, -195, -180, -150, -120, // 440
	-90, -60, -30, 0, 30, 60, 90, 120, // 448
	150, 180, 195, 210, 225, 240, 255, 270, // 456
	285, 300, 315, 330, 345, 390, 375, 360, // 464
	345, 330, 315, 300, 285, 270, 255, 240, // 472
	225, 210, 195, 165, 135, 105, 75, 45, // 480
	15, -15, -45, -75, -105, -135, -165, -195, // 488
	-210, -225, -240, -255, -270, -285, -300, -315, // 496
	-330, -345, -360, -375, -390, -375, -360, -345, // 504
	-330, -315, -300, -285, -270, -255, -240, -225, // 512
	-210, -195, -165, -135, -105, -75, -45, -15, // 520
	15, 45, 75, 105, 135, 165, 195, 210, // 528
	225, 240, 255, 270, 285, 300, 315, 330, // 536
	345, 360, 375, 420, 405, 390, 375, 360, // 544
	345, 330, 315, 300, 285, 270, 255, 240, // 552
	225, 210, 180, 150, 120, 90, 60, 30, // 560
	0, -30, -60, -90, -120, -150, -180, -210, // 568
	-225, -240, -255, -270, -285, -300, -315, -330, // 576
	-345, -360, -375, -390, -405, -420, -405, -390, // 584
	-375, -360, -345, -330, -315, -300, -285, -270, // 592
	-255, -240, -225, -210, -180, -150, -120, -90, // 600
	-60, -30, 0, 30, 60, 90, 120, 150, // 608
	180, 210, 225, 240, 255, 270, 285, 300, // 616
	315, 330, 345, 360, 375, 390, 405, 450, // 624
	435, 420, 405, 390, 375, 360, 345, 330, // 632
	315, 300, 285, 270, 255, 240, 225, 195, // 640
	165, 135, 105, 75, 45, 15, -15, -45, // 648
	-75, -105, -135, -165, -195, -225, -240, -255, // 656
	-270, -285, -300, -315, -330, -345, -360, -375, // 664
	-390, -405, -420, -435, -450, -435, -420, -405, // 672
	-390, -375, -360, -345, -330, -315, -300, -285, // 680
	-270, -255, -240, -225, -195, -165, -135, -105, // 688
	-75, -45, -15, 15, 45, 75, 105, 135, // 696
	165, 195, 225, 240, 255, 270, 285, 300, // 704
	315, 330, 345, 360, 375, 390, 405, 420, // 712
	435, 480, 465, 450, 435, 420, 405, 390, // 720
	375, 360, 345, 330, 315, 300, 285, 270, // 728
	255, 240, 210, 180, 150, 120, 90, 60, // 736
	30, 0, -30, -60, -90, -120, -150, -180, // 744
	-210, -240, -255, -270, -285, -300, -315, -330, // 752
	-345, -360, -375, -390, -405, -420, -435, -450, // 760
	-465, -480, -465, -450, -435, -420, -405, -390, // 768
	-375, -360, -345, -330, -315, -300, -285, -270, // 776
	-255, -240, -210, -180, -150, -120, -90, -60, // 784
	-30, 0, 30, 60, 90, 120, 150, 180, // 792
	210, 240, 255, 270, 285, 300, 315, 330, // 800
	345, 360, 375, 390, 405, 420, 435, 450, // 808
	465, 510, 495, 480, 465, 450, 435, 420, // 816
	405, 390, 375, 360, 345, 330, 315, 300, // 824
	285, 270, 255, 225, 195, 165, 135, 105, // 832
	75, 45, 15, -15, -45, -75, -105, -135, // 840
	-165, -195, -225, -255, -270, -285, -300, -315, // 848
	-330, -345, -360, -375, -390, -405, -420, -435, // 856
	-450, -465, -480, -495, -510, -495, -480, -465, // 864
	-450, -435, -420, -405, -390, -375, -360, -345, // 872
	-330, -315, -300, -285, -270, -255, -225, -195, // 880
	-165, -135, -105, -75, -45, -15, 15, 45, // 888
	75, 105, 135, 165, 195, 225, 255, 270, // 896
	285, 300, 315, 330, 345, 360, 375, 390, // 904
	405, 420, 435, 450, 465, 480, 495//919
  };

  const float ytemp[919] = {
	0, 0, 25.9808, 25.9808, -0, -25.9808, -25.9808, 0, // 0
	25.9808, 51.9615, 51.9615, 51.9615, 25.9808, -0, -25.9808, -51.9615, // 8
	-51.9615, -51.9615, -25.9808, 0, 25.9808, 51.9615, 77.9423, 77.9423, // 16
	77.9423, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 24
	-77.9423, -77.9423, -77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, // 32
	77.9423, 103.923, 103.923, 103.923, 103.923, 103.923, 77.9423, 51.9615, // 40
	25.9808, -0, -25.9808, -51.9615, -77.9423, -103.923, -103.923, -103.923, // 48
	-103.923, -103.923, -77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, // 56
	77.9423, 103.923, 129.904, 129.904, 129.904, 129.904, 129.904, 129.904, // 64
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 72
	-103.923, -129.904, -129.904, -129.904, -129.904, -129.904, -129.904, -103.923, // 80
	-77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, // 88
	129.904, 155.885, 155.885, 155.885, 155.885, 155.885, 155.885, 155.885, // 96
	129.904, 103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, // 104
	-77.9423, -103.923, -129.904, -155.885, -155.885, -155.885, -155.885, -155.885, // 112
	-155.885, -155.885, -129.904, -103.923, -77.9423, -51.9615, -25.9808, 0, // 120
	25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, 181.865, 181.865, // 128
	181.865, 181.865, 181.865, 181.865, 181.865, 181.865, 155.885, 129.904, // 136
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 144
	-103.923, -129.904, -155.885, -181.865, -181.865, -181.865, -181.865, -181.865, // 152
	-181.865, -181.865, -181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, // 160
	-25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, // 168
	181.865, 207.846, 207.846, 207.846, 207.846, 207.846, 207.846, 207.846, // 176
	207.846, 207.846, 181.865, 155.885, 129.904, 103.923, 77.9423, 51.9615, // 184
	25.9808, -0, -25.9808, -51.9615, -77.9423, -103.923, -129.904, -155.885, // 192
	-181.865, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846, // 200
	-207.846, -207.846, -181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, // 208
	-25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, // 216
	181.865, 207.846, 233.827, 233.827, 233.827, 233.827, 233.827, 233.827, // 224
	233.827, 233.827, 233.827, 233.827, 207.846, 181.865, 155.885, 129.904, // 232
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 240
	-103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -233.827, -233.827, // 248
	-233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -207.846, // 256
	-181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, -25.9808, 0, // 264
	25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, 181.865, 207.846, // 272
	233.827, 259.808, 259.808, 259.808, 259.808, 259.808, 259.808, 259.808, // 280
	259.808, 259.808, 259.808, 259.808, 233.827, 207.846, 181.865, 155.885, // 288
	129.904, 103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, // 296
	-77.9423, -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, // 304
	-259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, // 312
	-259.808, -259.808, -233.827, -207.846, -181.865, -155.885, -129.904, -103.923, // 320
	-77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, // 328
	129.904, 155.885, 181.865, 207.846, 233.827, 259.808, 285.788, 285.788, // 336
	285.788, 285.788, 285.788, 285.788, 285.788, 285.788, 285.788, 285.788, // 344
	285.788, 285.788, 259.808, 233.827, 207.846, 181.865, 155.885, 129.904, // 352
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 360
	-103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788, // 368
	-285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, // 376
	-285.788, -285.788, -285.788, -259.808, -233.827, -207.846, -181.865, -155.885, // 384
	-129.904, -103.923, -77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, // 392
	77.9423, 103.923, 129.904, 155.885, 181.865, 207.846, 233.827, 259.808, // 400
	285.788, 311.769, 311.769, 311.769, 311.769, 311.769, 311.769, 311.769, // 408
	311.769, 311.769, 311.769, 311.769, 311.769, 311.769, 285.788, 259.808, // 416
	233.827, 207.846, 181.865, 155.885, 129.904, 103.923, 77.9423, 51.9615, // 424
	25.9808, -0, -25.9808, -51.9615, -77.9423, -103.923, -129.904, -155.885, // 432
	-181.865, -207.846, -233.827, -259.808, -285.788, -311.769, -311.769, -311.769, // 440
	-311.769, -311.769, -311.769, -311.769, -311.769, -311.769, -311.769, -311.769, // 448
	-311.769, -311.769, -285.788, -259.808, -233.827, -207.846, -181.865, -155.885, // 456
	-129.904, -103.923, -77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, // 464
	77.9423, 103.923, 129.904, 155.885, 181.865, 207.846, 233.827, 259.808, // 472
	285.788, 311.769, 337.75, 337.75, 337.75, 337.75, 337.75, 337.75, // 480
	337.75, 337.75, 337.75, 337.75, 337.75, 337.75, 337.75, 337.75, // 488
	311.769, 285.788, 259.808, 233.827, 207.846, 181.865, 155.885, 129.904, // 496
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 504
	-103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788, // 512
	-311.769, -337.75, -337.75, -337.75, -337.75, -337.75, -337.75, -337.75, // 520
	-337.75, -337.75, -337.75, -337.75, -337.75, -337.75, -337.75, -311.769, // 528
	-285.788, -259.808, -233.827, -207.846, -181.865, -155.885, -129.904, -103.923, // 536
	-77.9423, -51.9615, -25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, // 544
	129.904, 155.885, 181.865, 207.846, 233.827, 259.808, 285.788, 311.769, // 552
	337.75, 363.731, 363.731, 363.731, 363.731, 363.731, 363.731, 363.731, // 560
	363.731, 363.731, 363.731, 363.731, 363.731, 363.731, 363.731, 363.731, // 568
	337.75, 311.769, 285.788, 259.808, 233.827, 207.846, 181.865, 155.885, // 576
	129.904, 103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, // 584
	-77.9423, -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, // 592
	-285.788, -311.769, -337.75, -363.731, -363.731, -363.731, -363.731, -363.731, // 600
	-363.731, -363.731, -363.731, -363.731, -363.731, -363.731, -363.731, -363.731, // 608
	-363.731, -363.731, -337.75, -311.769, -285.788, -259.808, -233.827, -207.846, // 616
	-181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, -25.9808, 0, // 624
	25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, 181.865, 207.846, // 632
	233.827, 259.808, 285.788, 311.769, 337.75, 363.731, 389.711, 389.711, // 640
	389.711, 389.711, 389.711, 389.711, 389.711, 389.711, 389.711, 389.711, // 648
	389.711, 389.711, 389.711, 389.711, 389.711, 389.711, 363.731, 337.75, // 656
	311.769, 285.788, 259.808, 233.827, 207.846, 181.865, 155.885, 129.904, // 664
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 672
	-103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788, // 680
	-311.769, -337.75, -363.731, -389.711, -389.711, -389.711, -389.711, -389.711, // 688
	-389.711, -389.711, -389.711, -389.711, -389.711, -389.711, -389.711, -389.711, // 696
	-389.711, -389.711, -389.711, -363.731, -337.75, -311.769, -285.788, -259.808, // 704
	-233.827, -207.846, -181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, // 712
	-25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, // 720
	181.865, 207.846, 233.827, 259.808, 285.788, 311.769, 337.75, 363.731, // 728
	389.711, 415.692, 415.692, 415.692, 415.692, 415.692, 415.692, 415.692, // 736
	415.692, 415.692, 415.692, 415.692, 415.692, 415.692, 415.692, 415.692, // 744
	415.692, 415.692, 389.711, 363.731, 337.75, 311.769, 285.788, 259.808, // 752
	233.827, 207.846, 181.865, 155.885, 129.904, 103.923, 77.9423, 51.9615, // 760
	25.9808, -0, -25.9808, -51.9615, -77.9423, -103.923, -129.904, -155.885, // 768
	-181.865, -207.846, -233.827, -259.808, -285.788, -311.769, -337.75, -363.731, // 776
	-389.711, -415.692, -415.692, -415.692, -415.692, -415.692, -415.692, -415.692, // 784
	-415.692, -415.692, -415.692, -415.692, -415.692, -415.692, -415.692, -415.692, // 792
	-415.692, -415.692, -389.711, -363.731, -337.75, -311.769, -285.788, -259.808, // 800
	-233.827, -207.846, -181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, // 808
	-25.9808, 0, 25.9808, 51.9615, 77.9423, 103.923, 129.904, 155.885, // 816
	181.865, 207.846, 233.827, 259.808, 285.788, 311.769, 337.75, 363.731, // 824
	389.711, 415.692, 441.673, 441.673, 441.673, 441.673, 441.673, 441.673, // 832
	441.673, 441.673, 441.673, 441.673, 441.673, 441.673, 441.673, 441.673, // 840
	441.673, 441.673, 441.673, 441.673, 415.692, 389.711, 363.731, 337.75, // 848
	311.769, 285.788, 259.808, 233.827, 207.846, 181.865, 155.885, 129.904, // 856
	103.923, 77.9423, 51.9615, 25.9808, -0, -25.9808, -51.9615, -77.9423, // 864
	-103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788, // 872
	-311.769, -337.75, -363.731, -389.711, -415.692, -441.673, -441.673, -441.673, // 880
	-441.673, -441.673, -441.673, -441.673, -441.673, -441.673, -441.673, -441.673, // 888
	-441.673, -441.673, -441.673, -441.673, -441.673, -441.673, -441.673, -415.692, // 896
	-389.711, -363.731, -337.75, -311.769, -285.788, -259.808, -233.827, -207.846, // 904
	-181.865, -155.885, -129.904, -103.923, -77.9423, -51.9615, -25.9808 //919
  };

  const float rtemp[919] = {
	30, 30, 30, 30, 30, 30, 30, 30, // 0
	30, 30, 30, 30, 30, 30, 30, 30, // 8
	30, 30, 30, 30, 30, 30, 30, 30, // 16
	30, 30, 30, 30, 30, 30, 30, 30, // 24
	30, 30, 30, 30, 30, 30, 30, 30, // 32
	30, 30, 30, 30, 30, 30, 30, 30, // 40
	30, 30, 30, 30, 30, 30, 30, 30, // 48
	30, 30, 30, 30, 30, 30, 30, 30, // 56
	30, 30, 30, 30, 30, 30, 30, 30, // 64
	30, 30, 30, 30, 30, 30, 30, 30, // 72
	30, 30, 30, 30, 30, 30, 30, 30, // 80
	30, 30, 30, 30, 30, 30, 30, 30, // 88
	30, 30, 30, 30, 30, 30, 30, 30, // 96
	30, 30, 30, 30, 30, 30, 30, 30, // 104
	30, 30, 30, 30, 30, 30, 30, 30, // 112
	30, 30, 30, 30, 30, 30, 30, 30, // 120
	30, 30, 30, 30, 30, 30, 30, 30, // 128
	30, 30, 30, 30, 30, 30, 30, 30, // 136
	30, 30, 30, 30, 30, 30, 30, 30, // 144
	30, 30, 30, 30, 30, 30, 30, 30, // 152
	30, 30, 30, 30, 30, 30, 30, 30, // 160
	30, 30, 30, 30, 30, 30, 30, 30, // 168
	30, 30, 30, 30, 30, 30, 30, 30, // 176
	30, 30, 30, 30, 30, 30, 30, 30, // 184
	30, 30, 30, 30, 30, 30, 30, 30, // 192
	30, 30, 30, 30, 30, 30, 30, 30, // 200
	30, 30, 30, 30, 30, 30, 30, 30, // 208
	30, 30, 30, 30, 30, 30, 30, 30, // 216
	30, 30, 30, 30, 30, 30, 30, 30, // 224
	30, 30, 30, 30, 30, 30, 30, 30, // 232
	30, 30, 30, 30, 30, 30, 30, 30, // 240
	30, 30, 30, 30, 30, 30, 30, 30, // 248
	30, 30, 30, 30, 30, 30, 30, 30, // 256
	30, 30, 30, 30, 30, 30, 30, 30, // 264
	30, 30, 30, 30, 30, 30, 30, 30, // 272
	30, 30, 30, 30, 30, 30, 30, 30, // 280
	30, 30, 30, 30, 30, 30, 30, 30, // 288
	30, 30, 30, 30, 30, 30, 30, 30, // 296
	30, 30, 30, 30, 30, 30, 30, 30, // 304
	30, 30, 30, 30, 30, 30, 30, 30, // 312
	30, 30, 30, 30, 30, 30, 30, 30, // 320
	30, 30, 30, 30, 30, 30, 30, 30, // 328
	30, 30, 30, 30, 30, 30, 30, 30, // 336
	30, 30, 30, 30, 30, 30, 30, 30, // 344
	30, 30, 30, 30, 30, 30, 30, 30, // 352
	30, 30, 30, 30, 30, 30, 30, 30, // 360
	30, 30, 30, 30, 30, 30, 30, 30, // 368
	30, 30, 30, 30, 30, 30, 30, 30, // 376
	30, 30, 30, 30, 30, 30, 30, 30, // 384
	30, 30, 30, 30, 30, 30, 30, 30, // 392
	30, 30, 30, 30, 30, 30, 30, 30, // 400
	30, 30, 30, 30, 30, 30, 30, 30, // 408
	30, 30, 30, 30, 30, 30, 30, 30, // 416
	30, 30, 30, 30, 30, 30, 30, 30, // 424
	30, 30, 30, 30, 30, 30, 30, 30, // 432
	30, 30, 30, 30, 30, 30, 30, 30, // 440
	30, 30, 30, 30, 30, 30, 30, 30, // 448
	30, 30, 30, 30, 30, 30, 30, 30, // 456
	30, 30, 30, 30, 30, 30, 30, 30, // 464
	30, 30, 30, 30, 30, 30, 30, 30, // 472
	30, 30, 30, 30, 30, 30, 30, 30, // 480
	30, 30, 30, 30, 30, 30, 30, 30, // 488
	30, 30, 30, 30, 30, 30, 30, 30, // 496
	30, 30, 30, 30, 30, 30, 30, 30, // 504
	30, 30, 30, 30, 30, 30, 30, 30, // 512
	30, 30, 30, 30, 30, 30, 30, 30, // 520
	30, 30, 30, 30, 30, 30, 30, 30, // 528
	30, 30, 30, 30, 30, 30, 30, 30, // 536
	30, 30, 30, 30, 30, 30, 30, 30, // 544
	30, 30, 30, 30, 30, 30, 30, 30, // 552
	30, 30, 30, 30, 30, 30, 30, 30, // 560
	30, 30, 30, 30, 30, 30, 30, 30, // 568
	30, 30, 30, 30, 30, 30, 30, 30, // 576
	30, 30, 30, 30, 30, 30, 30, 30, // 584
	30, 30, 30, 30, 30, 30, 30, 30, // 592
	30, 30, 30, 30, 30, 30, 30, 30, // 600
	30, 30, 30, 30, 30, 30, 30, 30, // 608
	30, 30, 30, 30, 30, 30, 30, 30, // 616
	30, 30, 30, 30, 30, 30, 30, 30, // 624
	30, 30, 30, 30, 30, 30, 30, 30, // 632
	30, 30, 30, 30, 30, 30, 30, 30, // 640
	30, 30, 30, 30, 30, 30, 30, 30, // 648
	30, 30, 30, 30, 30, 30, 30, 30, // 656
	30, 30, 30, 30, 30, 30, 30, 30, // 664
	30, 30, 30, 30, 30, 30, 30, 30, // 672
	30, 30, 30, 30, 30, 30, 30, 30, // 680
	30, 30, 30, 30, 30, 30, 30, 30, // 688
	30, 30, 30, 30, 30, 30, 30, 30, // 696
	30, 30, 30, 30, 30, 30, 30, 30, // 704
	30, 30, 30, 30, 30, 30, 30, 30, // 712
	30, 30, 30, 30, 30, 30, 30, 30, // 720
	30, 30, 30, 30, 30, 30, 30, 30, // 728
	30, 30, 30, 30, 30, 30, 30, 30, // 736
	30, 30, 30, 30, 30, 30, 30, 30, // 744
	30, 30, 30, 30, 30, 30, 30, 30, // 752
	30, 30, 30, 30, 30, 30, 30, 30, // 760
	30, 30, 30, 30, 30, 30, 30, 30, // 768
	30, 30, 30, 30, 30, 30, 30, 30, // 776
	30, 30, 30, 30, 30, 30, 30, 30, // 784
	30, 30, 30, 30, 30, 30, 30, 30, // 792
	30, 30, 30, 30, 30, 30, 30, 30, // 800
	30, 30, 30, 30, 30, 30, 30, 30, // 808
	30, 30, 30, 30, 30, 30, 30, 30, // 816
	30, 30, 30, 30, 30, 30, 30, 30, // 824
	30, 30, 30, 30, 30, 30, 30, 30, // 832
	30, 30, 30, 30, 30, 30, 30, 30, // 840
	30, 30, 30, 30, 30, 30, 30, 30, // 848
	30, 30, 30, 30, 30, 30, 30, 30, // 856
	30, 30, 30, 30, 30, 30, 30, 30, // 864
	30, 30, 30, 30, 30, 30, 30, 30, // 872
	30, 30, 30, 30, 30, 30, 30, 30, // 880
	30, 30, 30, 30, 30, 30, 30, 30, // 888
	30, 30, 30, 30, 30, 30, 30, 30, // 896
	30, 30, 30, 30, 30, 30, 30, 30, // 904
	30, 30, 30, 30, 30, 30, 30//919
};

    //
    //   fill the pixels list with this data
    //

    for (UInt_t i=0; i<GetNumPixels(); i++)
        (*this)[i].Set(xtemp[i], ytemp[i], rtemp[i]) ;
}

// --------------------------------------------------------------------------
//
//  This fills the next neighbor information from a table into the pixel
//  objects.
//
void MGeomCamMagic919::CreateNN()
{
  const Short_t nn[919][6] = {       // Neighbours of  #
	{  1,	2,	3,	4,	5,	6},// 0
	{  0,	2,	6,	7,	8,	18},
	{  0,	1,	3,	8,	9,	10},
	{  0,	2,	4,	10,	11,	12},
	{  0,	3,	5,	12,	13,	14},
	{  0,	4,	6,	14,	15,	16},
	{  0,	1,	5,	16,	17,	18},
	{  1,	8,	18,	19,	20,	36},
	{  1,	2,	7,	9,	20,	21},
	{  2,	8,	10,	21,	22,	23},
	{  2,	3,	9,	11,	23,	24},
	{  3,	10,	12,	24,	25,	26},
	{  3,	4,	11,	13,	26,	27},
	{  4,	12,	14,	27,	28,	29},
	{  4,	5,	13,	15,	29,	30},
	{  5,	14,	16,	30,	31,	32},
	{  5,	6,	15,	17,	32,	33},
	{  6,	16,	18,	33,	34,	35},
	{  1,	6,	7,	17,	35,	36},
	{  7,	20,	36,	37,	38,	60},
	{  7,	8,	19,	21,	38,	39},// 20
	{  8,	9,	20,	22,	39,	40},
	{  9,	21,	23,	40,	41,	42},
	{  9,	10,	22,	24,	42,	43},
	{  10,	11,	23,	25,	43,	44},
	{  11,	24,	26,	44,	45,	46},
	{  11,	12,	25,	27,	46,	47},
	{  12,	13,	26,	28,	47,	48},
	{  13,	27,	29,	48,	49,	50},
	{  13,	14,	28,	30,	50,	51},
	{  14,	15,	29,	31,	51,	52},
	{  15,	30,	32,	52,	53,	54},
	{  15,	16,	31,	33,	54,	55},
	{  16,	17,	32,	34,	55,	56},
	{  17,	33,	35,	56,	57,	58},
	{  17,	18,	34,	36,	58,	59},
	{  7,	18,	19,	35,	59,	60},
	{  19,	38,	60,	61,	62,	90},
	{  19,	20,	37,	39,	62,	63},
	{  20,	21,	38,	40,	63,	64},
	{  21,	22,	39,	41,	64,	65},// 40
	{  22,	40,	42,	65,	66,	67},
	{  22,	23,	41,	43,	67,	68},
	{  23,	24,	42,	44,	68,	69},
	{  24,	25,	43,	45,	69,	70},
	{  25,	44,	46,	70,	71,	72},
	{  25,	26,	45,	47,	72,	73},
	{  26,	27,	46,	48,	73,	74},
	{  27,	28,	47,	49,	74,	75},
	{  28,	48,	50,	75,	76,	77},
	{  28,	29,	49,	51,	77,	78},
	{  29,	30,	50,	52,	78,	79},
	{  30,	31,	51,	53,	79,	80},
	{  31,	52,	54,	80,	81,	82},
	{  31,	32,	53,	55,	82,	83},
	{  32,	33,	54,	56,	83,	84},
	{  33,	34,	55,	57,	84,	85},
	{  34,	56,	58,	85,	86,	87},
	{  34,	35,	57,	59,	87,	88},
	{  35,	36,	58,	60,	88,	89},
	{  19,	36,	37,	59,	89,	90},// 60
	{  37,	62,	90,	91,	92,	126},
	{  37,	38,	61,	63,	92,	93},
	{  38,	39,	62,	64,	93,	94},
	{  39,	40,	63,	65,	94,	95},
	{  40,	41,	64,	66,	95,	96},
	{  41,	65,	67,	96,	97,	98},
	{  41,	42,	66,	68,	98,	99},
	{  42,	43,	67,	69,	99,	100},
	{  43,	44,	68,	70,	100,	101},
	{  44,	45,	69,	71,	101,	102},
	{  45,	70,	72,	102,	103,	104},
	{  45,	46,	71,	73,	104,	105},
	{  46,	47,	72,	74,	105,	106},
	{  47,	48,	73,	75,	106,	107},
	{  48,	49,	74,	76,	107,	108},
	{  49,	75,	77,	108,	109,	110},
	{  49,	50,	76,	78,	110,	111},
	{  50,	51,	77,	79,	111,	112},
	{  51,	52,	78,	80,	112,	113},
	{  52,	53,	79,	81,	113,	114},// 80
	{  53,	80,	82,	114,	115,	116},
	{  53,	54,	81,	83,	116,	117},
	{  54,	55,	82,	84,	117,	118},
	{  55,	56,	83,	85,	118,	119},
	{  56,	57,	84,	86,	119,	120},
	{  57,	85,	87,	120,	121,	122},
	{  57,	58,	86,	88,	122,	123},
	{  58,	59,	87,	89,	123,	124},
	{  59,	60,	88,	90,	124,	125},
	{  37,	60,	61,	89,	125,	126},
	{  61,	92,	126,	127,	128,	168},
	{  61,	62,	91,	93,	128,	129},
	{  62,	63,	92,	94,	129,	130},
	{  63,	64,	93,	95,	130,	131},
	{  64,	65,	94,	96,	131,	132},
	{  65,	66,	95,	97,	132,	133},
	{  66,	96,	98,	133,	134,	135},
	{  66,	67,	97,	99,	135,	136},
	{  67,	68,	98,	100,	136,	137},
	{  68,	69,	99,	101,	137,	138},// 100
	{  69,	70,	100,	102,	138,	139},
	{  70,	71,	101,	103,	139,	140},
	{  71,	102,	104,	140,	141,	142},
	{  71,	72,	103,	105,	142,	143},
	{  72,	73,	104,	106,	143,	144},
	{  73,	74,	105,	107,	144,	145},
	{  74,	75,	106,	108,	145,	146},
	{  75,	76,	107,	109,	146,	147},
	{  76,	108,	110,	147,	148,	149},
	{  76,	77,	109,	111,	149,	150},
	{  77,	78,	110,	112,	150,	151},
	{  78,	79,	111,	113,	151,	152},
	{  79,	80,	112,	114,	152,	153},
	{  80,	81,	113,	115,	153,	154},
	{  81,	114,	116,	154,	155,	156},
	{  81,	82,	115,	117,	156,	157},
	{  82,	83,	116,	118,	157,	158},
	{  83,	84,	117,	119,	158,	159},
	{  84,	85,	118,	120,	159,	160},
	{  85,	86,	119,	121,	160,	161},// 120
	{  86,	120,	122,	161,	162,	163},
	{  86,	87,	121,	123,	163,	164},
	{  87,	88,	122,	124,	164,	165},
	{  88,	89,	123,	125,	165,	166},
	{  89,	90,	124,	126,	166,	167},
	{  61,	90,	91,	125,	167,	168},
	{  91,	128,	168,	169,	170,	216},
	{  91,	92,	127,	129,	170,	171},
	{  92,	93,	128,	130,	171,	172},
	{  93,	94,	129,	131,	172,	173},
	{  94,	95,	130,	132,	173,	174},
	{  95,	96,	131,	133,	174,	175},
	{  96,	97,	132,	134,	175,	176},
	{  97,	133,	135,	176,	177,	178},
	{  97,	98,	134,	136,	178,	179},
	{  98,	99,	135,	137,	179,	180},
	{  99,	100,	136,	138,	180,	181},
	{  100,	101,	137,	139,	181,	182},
	{  101,	102,	138,	140,	182,	183},
	{  102,	103,	139,	141,	183,	184},// 140
	{  103,	140,	142,	184,	185,	186},
	{  103,	104,	141,	143,	186,	187},
	{  104,	105,	142,	144,	187,	188},
	{  105,	106,	143,	145,	188,	189},
	{  106,	107,	144,	146,	189,	190},
	{  107,	108,	145,	147,	190,	191},
	{  108,	109,	146,	148,	191,	192},
	{  109,	147,	149,	192,	193,	194},
	{  109,	110,	148,	150,	194,	195},
	{  110,	111,	149,	151,	195,	196},
	{  111,	112,	150,	152,	196,	197},
	{  112,	113,	151,	153,	197,	198},
	{  113,	114,	152,	154,	198,	199},
	{  114,	115,	153,	155,	199,	200},
	{  115,	154,	156,	200,	201,	202},
	{  115,	116,	155,	157,	202,	203},
	{  116,	117,	156,	158,	203,	204},
	{  117,	118,	157,	159,	204,	205},
	{  118,	119,	158,	160,	205,	206},
	{  119,	120,	159,	161,	206,	207},// 160
	{  120,	121,	160,	162,	207,	208},
	{  121,	161,	163,	208,	209,	210},
	{  121,	122,	162,	164,	210,	211},
	{  122,	123,	163,	165,	211,	212},
	{  123,	124,	164,	166,	212,	213},
	{  124,	125,	165,	167,	213,	214},
	{  125,	126,	166,	168,	214,	215},
	{  91,	126,	127,	167,	215,	216},
	{  127,	170,	216,	217,	218,	270},
	{  127,	128,	169,	171,	218,	219},
	{  128,	129,	170,	172,	219,	220},
	{  129,	130,	171,	173,	220,	221},
	{  130,	131,	172,	174,	221,	222},
	{  131,	132,	173,	175,	222,	223},
	{  132,	133,	174,	176,	223,	224},
	{  133,	134,	175,	177,	224,	225},
	{  134,	176,	178,	225,	226,	227},
	{  134,	135,	177,	179,	227,	228},
	{  135,	136,	178,	180,	228,	229},
	{  136,	137,	179,	181,	229,	230},// 180
	{  137,	138,	180,	182,	230,	231},
	{  138,	139,	181,	183,	231,	232},
	{  139,	140,	182,	184,	232,	233},
	{  140,	141,	183,	185,	233,	234},
	{  141,	184,	186,	234,	235,	236},
	{  141,	142,	185,	187,	236,	237},
	{  142,	143,	186,	188,	237,	238},
	{  143,	144,	187,	189,	238,	239},
	{  144,	145,	188,	190,	239,	240},
	{  145,	146,	189,	191,	240,	241},
	{  146,	147,	190,	192,	241,	242},
	{  147,	148,	191,	193,	242,	243},
	{  148,	192,	194,	243,	244,	245},
	{  148,	149,	193,	195,	245,	246},
	{  149,	150,	194,	196,	246,	247},
	{  150,	151,	195,	197,	247,	248},
	{  151,	152,	196,	198,	248,	249},
	{  152,	153,	197,	199,	249,	250},
	{  153,	154,	198,	200,	250,	251},
	{  154,	155,	199,	201,	251,	252},// 200
	{  155,	200,	202,	252,	253,	254},
	{  155,	156,	201,	203,	254,	255},
	{  156,	157,	202,	204,	255,	256},
	{  157,	158,	203,	205,	256,	257},
	{  158,	159,	204,	206,	257,	258},
	{  159,	160,	205,	207,	258,	259},
	{  160,	161,	206,	208,	259,	260},
	{  161,	162,	207,	209,	260,	261},
	{  162,	208,	210,	261,	262,	263},
	{  162,	163,	209,	211,	263,	264},
	{  163,	164,	210,	212,	264,	265},
	{  164,	165,	211,	213,	265,	266},
	{  165,	166,	212,	214,	266,	267},
	{  166,	167,	213,	215,	267,	268},
	{  167,	168,	214,	216,	268,	269},
	{  127,	168,	169,	215,	269,	270},
	{  169,	218,	270,	271,	272,	330},
	{  169,	170,	217,	219,	272,	273},
	{  170,	171,	218,	220,	273,	274},
	{  171,	172,	219,	221,	274,	275},// 220
	{  172,	173,	220,	222,	275,	276},
	{  173,	174,	221,	223,	276,	277},
	{  174,	175,	222,	224,	277,	278},
	{  175,	176,	223,	225,	278,	279},
	{  176,	177,	224,	226,	279,	280},
	{  177,	225,	227,	280,	281,	282},
	{  177,	178,	226,	228,	282,	283},
	{  178,	179,	227,	229,	283,	284},
	{  179,	180,	228,	230,	284,	285},
	{  180,	181,	229,	231,	285,	286},
	{  181,	182,	230,	232,	286,	287},
	{  182,	183,	231,	233,	287,	288},
	{  183,	184,	232,	234,	288,	289},
	{  184,	185,	233,	235,	289,	290},
	{  185,	234,	236,	290,	291,	292},
	{  185,	186,	235,	237,	292,	293},
	{  186,	187,	236,	238,	293,	294},
	{  187,	188,	237,	239,	294,	295},
	{  188,	189,	238,	240,	295,	296},
	{  189,	190,	239,	241,	296,	297},// 240
	{  190,	191,	240,	242,	297,	298},
	{  191,	192,	241,	243,	298,	299},
	{  192,	193,	242,	244,	299,	300},
	{  193,	243,	245,	300,	301,	302},
	{  193,	194,	244,	246,	302,	303},
	{  194,	195,	245,	247,	303,	304},
	{  195,	196,	246,	248,	304,	305},
	{  196,	197,	247,	249,	305,	306},
	{  197,	198,	248,	250,	306,	307},
	{  198,	199,	249,	251,	307,	308},
	{  199,	200,	250,	252,	308,	309},
	{  200,	201,	251,	253,	309,	310},
	{  201,	252,	254,	310,	311,	312},
	{  201,	202,	253,	255,	312,	313},
	{  202,	203,	254,	256,	313,	314},
	{  203,	204,	255,	257,	314,	315},
	{  204,	205,	256,	258,	315,	316},
	{  205,	206,	257,	259,	316,	317},
	{  206,	207,	258,	260,	317,	318},
	{  207,	208,	259,	261,	318,	319},// 260
	{  208,	209,	260,	262,	319,	320},
	{  209,	261,	263,	320,	321,	322},
	{  209,	210,	262,	264,	322,	323},
	{  210,	211,	263,	265,	323,	324},
	{  211,	212,	264,	266,	324,	325},
	{  212,	213,	265,	267,	325,	326},
	{  213,	214,	266,	268,	326,	327},
	{  214,	215,	267,	269,	327,	328},
	{  215,	216,	268,	270,	328,	329},
	{  169,	216,	217,	269,	329,	330},
	{  217,	272,	330,	331,	332,	396},
	{  217,	218,	271,	273,	332,	333},
	{  218,	219,	272,	274,	333,	334},
	{  219,	220,	273,	275,	334,	335},
	{  220,	221,	274,	276,	335,	336},
	{  221,	222,	275,	277,	336,	337},
	{  222,	223,	276,	278,	337,	338},
	{  223,	224,	277,	279,	338,	339},
	{  224,	225,	278,	280,	339,	340},
	{  225,	226,	279,	281,	340,	341},// 280
	{  226,	280,	282,	341,	342,	343},
	{  226,	227,	281,	283,	343,	344},
	{  227,	228,	282,	284,	344,	345},
	{  228,	229,	283,	285,	345,	346},
	{  229,	230,	284,	286,	346,	347},
	{  230,	231,	285,	287,	347,	348},
	{  231,	232,	286,	288,	348,	349},
	{  232,	233,	287,	289,	349,	350},
	{  233,	234,	288,	290,	350,	351},
	{  234,	235,	289,	291,	351,	352},
	{  235,	290,	292,	352,	353,	354},
	{  235,	236,	291,	293,	354,	355},
	{  236,	237,	292,	294,	355,	356},
	{  237,	238,	293,	295,	356,	357},
	{  238,	239,	294,	296,	357,	358},
	{  239,	240,	295,	297,	358,	359},
	{  240,	241,	296,	298,	359,	360},
	{  241,	242,	297,	299,	360,	361},
	{  242,	243,	298,	300,	361,	362},
	{  243,	244,	299,	301,	362,	363},// 300
	{  244,	300,	302,	363,	364,	365},
	{  244,	245,	301,	303,	365,	366},
	{  245,	246,	302,	304,	366,	367},
	{  246,	247,	303,	305,	367,	368},
	{  247,	248,	304,	306,	368,	369},
	{  248,	249,	305,	307,	369,	370},
	{  249,	250,	306,	308,	370,	371},
	{  250,	251,	307,	309,	371,	372},
	{  251,	252,	308,	310,	372,	373},
	{  252,	253,	309,	311,	373,	374},
	{  253,	310,	312,	374,	375,	376},
	{  253,	254,	311,	313,	376,	377},
	{  254,	255,	312,	314,	377,	378},
	{  255,	256,	313,	315,	378,	379},
	{  256,	257,	314,	316,	379,	380},
	{  257,	258,	315,	317,	380,	381},
	{  258,	259,	316,	318,	381,	382},
	{  259,	260,	317,	319,	382,	383},
	{  260,	261,	318,	320,	383,	384},
	{  261,	262,	319,	321,	384,	385},// 320
	{  262,	320,	322,	385,	386,	387},
	{  262,	263,	321,	323,	387,	388},
	{  263,	264,	322,	324,	388,	389},
	{  264,	265,	323,	325,	389,	390},
	{  265,	266,	324,	326,	390,	391},
	{  266,	267,	325,	327,	391,	392},
	{  267,	268,	326,	328,	392,	393},
	{  268,	269,	327,	329,	393,	394},
	{  269,	270,	328,	330,	394,	395},
	{  217,	270,	271,	329,	395,	396},
	{  271,	332,	396,	397,	398,	468},
	{  271,	272,	331,	333,	398,	399},
	{  272,	273,	332,	334,	399,	400},
	{  273,	274,	333,	335,	400,	401},
	{  274,	275,	334,	336,	401,	402},
	{  275,	276,	335,	337,	402,	403},
	{  276,	277,	336,	338,	403,	404},
	{  277,	278,	337,	339,	404,	405},
	{  278,	279,	338,	340,	405,	406},
	{  279,	280,	339,	341,	406,	407},// 340
	{  280,	281,	340,	342,	407,	408},
	{  281,	341,	343,	408,	409,	410},
	{  281,	282,	342,	344,	410,	411},
	{  282,	283,	343,	345,	411,	412},
	{  283,	284,	344,	346,	412,	413},
	{  284,	285,	345,	347,	413,	414},
	{  285,	286,	346,	348,	414,	415},
	{  286,	287,	347,	349,	415,	416},
	{  287,	288,	348,	350,	416,	417},
	{  288,	289,	349,	351,	417,	418},
	{  289,	290,	350,	352,	418,	419},
	{  290,	291,	351,	353,	419,	420},
	{  291,	352,	354,	420,	421,	422},
	{  291,	292,	353,	355,	422,	423},
	{  292,	293,	354,	356,	423,	424},
	{  293,	294,	355,	357,	424,	425},
	{  294,	295,	356,	358,	425,	426},
	{  295,	296,	357,	359,	426,	427},
	{  296,	297,	358,	360,	427,	428},
	{  297,	298,	359,	361,	428,	429},// 360
	{  298,	299,	360,	362,	429,	430},
	{  299,	300,	361,	363,	430,	431},
	{  300,	301,	362,	364,	431,	432},
	{  301,	363,	365,	432,	433,	434},
	{  301,	302,	364,	366,	434,	435},
	{  302,	303,	365,	367,	435,	436},
	{  303,	304,	366,	368,	436,	437},
	{  304,	305,	367,	369,	437,	438},
	{  305,	306,	368,	370,	438,	439},
	{  306,	307,	369,	371,	439,	440},
	{  307,	308,	370,	372,	440,	441},
	{  308,	309,	371,	373,	441,	442},
	{  309,	310,	372,	374,	442,	443},
	{  310,	311,	373,	375,	443,	444},
	{  311,	374,	376,	444,	445,	446},
	{  311,	312,	375,	377,	446,	447},
	{  312,	313,	376,	378,	447,	448},
	{  313,	314,	377,	379,	448,	449},
	{  314,	315,	378,	380,	449,	450},
	{  315,	316,	379,	381,	450,	451},// 380
	{  316,	317,	380,	382,	451,	452},
	{  317,	318,	381,	383,	452,	453},
	{  318,	319,	382,	384,	453,	454},
	{  319,	320,	383,	385,	454,	455},
	{  320,	321,	384,	386,	455,	456},
	{  321,	385,	387,	456,	457,	458},
	{  321,	322,	386,	388,	458,	459},
	{  322,	323,	387,	389,	459,	460},
	{  323,	324,	388,	390,	460,	461},
	{  324,	325,	389,	391,	461,	462},
	{  325,	326,	390,	392,	462,	463},
	{  326,	327,	391,	393,	463,	464},
	{  327,	328,	392,	394,	464,	465},
	{  328,	329,	393,	395,	465,	466},
	{  329,	330,	394,	396,	466,	467},
	{  271,	330,	331,	395,	467,	468},
	{  331,	398,	468,	469,	470,	546},
	{  331,	332,	397,	399,	470,	471},
	{  332,	333,	398,	400,	471,	472},
	{  333,	334,	399,	401,	472,	473},// 400
	{  334,	335,	400,	402,	473,	474},
	{  335,	336,	401,	403,	474,	475},
	{  336,	337,	402,	404,	475,	476},
	{  337,	338,	403,	405,	476,	477},
	{  338,	339,	404,	406,	477,	478},
	{  339,	340,	405,	407,	478,	479},
	{  340,	341,	406,	408,	479,	480},
	{  341,	342,	407,	409,	480,	481},
	{  342,	408,	410,	481,	482,	483},
	{  342,	343,	409,	411,	483,	484},
	{  343,	344,	410,	412,	484,	485},
	{  344,	345,	411,	413,	485,	486},
	{  345,	346,	412,	414,	486,	487},
	{  346,	347,	413,	415,	487,	488},
	{  347,	348,	414,	416,	488,	489},
	{  348,	349,	415,	417,	489,	490},
	{  349,	350,	416,	418,	490,	491},
	{  350,	351,	417,	419,	491,	492},
	{  351,	352,	418,	420,	492,	493},
	{  352,	353,	419,	421,	493,	494},// 420
	{  353,	420,	422,	494,	495,	496},
	{  353,	354,	421,	423,	496,	497},
	{  354,	355,	422,	424,	497,	498},
	{  355,	356,	423,	425,	498,	499},
	{  356,	357,	424,	426,	499,	500},
	{  357,	358,	425,	427,	500,	501},
	{  358,	359,	426,	428,	501,	502},
	{  359,	360,	427,	429,	502,	503},
	{  360,	361,	428,	430,	503,	504},
	{  361,	362,	429,	431,	504,	505},
	{  362,	363,	430,	432,	505,	506},
	{  363,	364,	431,	433,	506,	507},
	{  364,	432,	434,	507,	508,	509},
	{  364,	365,	433,	435,	509,	510},
	{  365,	366,	434,	436,	510,	511},
	{  366,	367,	435,	437,	511,	512},
	{  367,	368,	436,	438,	512,	513},
	{  368,	369,	437,	439,	513,	514},
	{  369,	370,	438,	440,	514,	515},
	{  370,	371,	439,	441,	515,	516},// 440
	{  371,	372,	440,	442,	516,	517},
	{  372,	373,	441,	443,	517,	518},
	{  373,	374,	442,	444,	518,	519},
	{  374,	375,	443,	445,	519,	520},
	{  375,	444,	446,	520,	521,	522},
	{  375,	376,	445,	447,	522,	523},
	{  376,	377,	446,	448,	523,	524},
	{  377,	378,	447,	449,	524,	525},
	{  378,	379,	448,	450,	525,	526},
	{  379,	380,	449,	451,	526,	527},
	{  380,	381,	450,	452,	527,	528},
	{  381,	382,	451,	453,	528,	529},
	{  382,	383,	452,	454,	529,	530},
	{  383,	384,	453,	455,	530,	531},
	{  384,	385,	454,	456,	531,	532},
	{  385,	386,	455,	457,	532,	533},
	{  386,	456,	458,	533,	534,	535},
	{  386,	387,	457,	459,	535,	536},
	{  387,	388,	458,	460,	536,	537},
	{  388,	389,	459,	461,	537,	538},// 460
	{  389,	390,	460,	462,	538,	539},
	{  390,	391,	461,	463,	539,	540},
	{  391,	392,	462,	464,	540,	541},
	{  392,	393,	463,	465,	541,	542},
	{  393,	394,	464,	466,	542,	543},
	{  394,	395,	465,	467,	543,	544},
	{  395,	396,	466,	468,	544,	545},
	{  331,	396,	397,	467,	545,	546},
	{  397,	470,	546,	547,	548,	630},
	{  397,	398,	469,	471,	548,	549},
	{  398,	399,	470,	472,	549,	550},
	{  399,	400,	471,	473,	550,	551},
	{  400,	401,	472,	474,	551,	552},
	{  401,	402,	473,	475,	552,	553},
	{  402,	403,	474,	476,	553,	554},
	{  403,	404,	475,	477,	554,	555},
	{  404,	405,	476,	478,	555,	556},
	{  405,	406,	477,	479,	556,	557},
	{  406,	407,	478,	480,	557,	558},
	{  407,	408,	479,	481,	558,	559},// 480
	{  408,	409,	480,	482,	559,	560},
	{  409,	481,	483,	560,	561,	562},
	{  409,	410,	482,	484,	562,	563},
	{  410,	411,	483,	485,	563,	564},
	{  411,	412,	484,	486,	564,	565},
	{  412,	413,	485,	487,	565,	566},
	{  413,	414,	486,	488,	566,	567},
	{  414,	415,	487,	489,	567,	568},
	{  415,	416,	488,	490,	568,	569},
	{  416,	417,	489,	491,	569,	570},
	{  417,	418,	490,	492,	570,	571},
	{  418,	419,	491,	493,	571,	572},
	{  419,	420,	492,	494,	572,	573},
	{  420,	421,	493,	495,	573,	574},
	{  421,	494,	496,	574,	575,	576},
	{  421,	422,	495,	497,	576,	577},
	{  422,	423,	496,	498,	577,	578},
	{  423,	424,	497,	499,	578,	579},
	{  424,	425,	498,	500,	579,	580},
	{  425,	426,	499,	501,	580,	581},// 500
	{  426,	427,	500,	502,	581,	582},
	{  427,	428,	501,	503,	582,	583},
	{  428,	429,	502,	504,	583,	584},
	{  429,	430,	503,	505,	584,	585},
	{  430,	431,	504,	506,	585,	586},
	{  431,	432,	505,	507,	586,	587},
	{  432,	433,	506,	508,	587,	588},
	{  433,	507,	509,	588,	589,	590},
	{  433,	434,	508,	510,	590,	591},
	{  434,	435,	509,	511,	591,	592},
	{  435,	436,	510,	512,	592,	593},
	{  436,	437,	511,	513,	593,	594},
	{  437,	438,	512,	514,	594,	595},
	{  438,	439,	513,	515,	595,	596},
	{  439,	440,	514,	516,	596,	597},
	{  440,	441,	515,	517,	597,	598},
	{  441,	442,	516,	518,	598,	599},
	{  442,	443,	517,	519,	599,	600},
	{  443,	444,	518,	520,	600,	601},
	{  444,	445,	519,	521,	601,	602},// 520
	{  445,	520,	522,	602,	603,	604},
	{  445,	446,	521,	523,	604,	605},
	{  446,	447,	522,	524,	605,	606},
	{  447,	448,	523,	525,	606,	607},
	{  448,	449,	524,	526,	607,	608},
	{  449,	450,	525,	527,	608,	609},
	{  450,	451,	526,	528,	609,	610},
	{  451,	452,	527,	529,	610,	611},
	{  452,	453,	528,	530,	611,	612},
	{  453,	454,	529,	531,	612,	613},
	{  454,	455,	530,	532,	613,	614},
	{  455,	456,	531,	533,	614,	615},
	{  456,	457,	532,	534,	615,	616},
	{  457,	533,	535,	616,	617,	618},
	{  457,	458,	534,	536,	618,	619},
	{  458,	459,	535,	537,	619,	620},
	{  459,	460,	536,	538,	620,	621},
	{  460,	461,	537,	539,	621,	622},
	{  461,	462,	538,	540,	622,	623},
	{  462,	463,	539,	541,	623,	624},// 540
	{  463,	464,	540,	542,	624,	625},
	{  464,	465,	541,	543,	625,	626},
	{  465,	466,	542,	544,	626,	627},
	{  466,	467,	543,	545,	627,	628},
	{  467,	468,	544,	546,	628,	629},
	{  397,	468,	469,	545,	629,	630},
	{  469,	548,	630,	631,	632,	720},
	{  469,	470,	547,	549,	632,	633},
	{  470,	471,	548,	550,	633,	634},
	{  471,	472,	549,	551,	634,	635},
	{  472,	473,	550,	552,	635,	636},
	{  473,	474,	551,	553,	636,	637},
	{  474,	475,	552,	554,	637,	638},
	{  475,	476,	553,	555,	638,	639},
	{  476,	477,	554,	556,	639,	640},
	{  477,	478,	555,	557,	640,	641},
	{  478,	479,	556,	558,	641,	642},
	{  479,	480,	557,	559,	642,	643},
	{  480,	481,	558,	560,	643,	644},
	{  481,	482,	559,	561,	644,	645},// 560
	{  482,	560,	562,	645,	646,	647},
	{  482,	483,	561,	563,	647,	648},
	{  483,	484,	562,	564,	648,	649},
	{  484,	485,	563,	565,	649,	650},
	{  485,	486,	564,	566,	650,	651},
	{  486,	487,	565,	567,	651,	652},
	{  487,	488,	566,	568,	652,	653},
	{  488,	489,	567,	569,	653,	654},
	{  489,	490,	568,	570,	654,	655},
	{  490,	491,	569,	571,	655,	656},
	{  491,	492,	570,	572,	656,	657},
	{  492,	493,	571,	573,	657,	658},
	{  493,	494,	572,	574,	658,	659},
	{  494,	495,	573,	575,	659,	660},
	{  495,	574,	576,	660,	661,	662},
	{  495,	496,	575,	577,	662,	663},
	{  496,	497,	576,	578,	663,	664},
	{  497,	498,	577,	579,	664,	665},
	{  498,	499,	578,	580,	665,	666},
	{  499,	500,	579,	581,	666,	667},// 580
	{  500,	501,	580,	582,	667,	668},
	{  501,	502,	581,	583,	668,	669},
	{  502,	503,	582,	584,	669,	670},
	{  503,	504,	583,	585,	670,	671},
	{  504,	505,	584,	586,	671,	672},
	{  505,	506,	585,	587,	672,	673},
	{  506,	507,	586,	588,	673,	674},
	{  507,	508,	587,	589,	674,	675},
	{  508,	588,	590,	675,	676,	677},
	{  508,	509,	589,	591,	677,	678},
	{  509,	510,	590,	592,	678,	679},
	{  510,	511,	591,	593,	679,	680},
	{  511,	512,	592,	594,	680,	681},
	{  512,	513,	593,	595,	681,	682},
	{  513,	514,	594,	596,	682,	683},
	{  514,	515,	595,	597,	683,	684},
	{  515,	516,	596,	598,	684,	685},
	{  516,	517,	597,	599,	685,	686},
	{  517,	518,	598,	600,	686,	687},
	{  518,	519,	599,	601,	687,	688},// 600
	{  519,	520,	600,	602,	688,	689},
	{  520,	521,	601,	603,	689,	690},
	{  521,	602,	604,	690,	691,	692},
	{  521,	522,	603,	605,	692,	693},
	{  522,	523,	604,	606,	693,	694},
	{  523,	524,	605,	607,	694,	695},
	{  524,	525,	606,	608,	695,	696},
	{  525,	526,	607,	609,	696,	697},
	{  526,	527,	608,	610,	697,	698},
	{  527,	528,	609,	611,	698,	699},
	{  528,	529,	610,	612,	699,	700},
	{  529,	530,	611,	613,	700,	701},
	{  530,	531,	612,	614,	701,	702},
	{  531,	532,	613,	615,	702,	703},
	{  532,	533,	614,	616,	703,	704},
	{  533,	534,	615,	617,	704,	705},
	{  534,	616,	618,	705,	706,	707},
	{  534,	535,	617,	619,	707,	708},
	{  535,	536,	618,	620,	708,	709},
	{  536,	537,	619,	621,	709,	710},// 620
	{  537,	538,	620,	622,	710,	711},
	{  538,	539,	621,	623,	711,	712},
	{  539,	540,	622,	624,	712,	713},
	{  540,	541,	623,	625,	713,	714},
	{  541,	542,	624,	626,	714,	715},
	{  542,	543,	625,	627,	715,	716},
	{  543,	544,	626,	628,	716,	717},
	{  544,	545,	627,	629,	717,	718},
	{  545,	546,	628,	630,	718,	719},
	{  469,	546,	547,	629,	719,	720},
	{  547,	632,	720,	721,	722,	816},
	{  547,	548,	631,	633,	722,	723},
	{  548,	549,	632,	634,	723,	724},
	{  549,	550,	633,	635,	724,	725},
	{  550,	551,	634,	636,	725,	726},
	{  551,	552,	635,	637,	726,	727},
	{  552,	553,	636,	638,	727,	728},
	{  553,	554,	637,	639,	728,	729},
	{  554,	555,	638,	640,	729,	730},
	{  555,	556,	639,	641,	730,	731},// 640
	{  556,	557,	640,	642,	731,	732},
	{  557,	558,	641,	643,	732,	733},
	{  558,	559,	642,	644,	733,	734},
	{  559,	560,	643,	645,	734,	735},
	{  560,	561,	644,	646,	735,	736},
	{  561,	645,	647,	736,	737,	738},
	{  561,	562,	646,	648,	738,	739},
	{  562,	563,	647,	649,	739,	740},
	{  563,	564,	648,	650,	740,	741},
	{  564,	565,	649,	651,	741,	742},
	{  565,	566,	650,	652,	742,	743},
	{  566,	567,	651,	653,	743,	744},
	{  567,	568,	652,	654,	744,	745},
	{  568,	569,	653,	655,	745,	746},
	{  569,	570,	654,	656,	746,	747},
	{  570,	571,	655,	657,	747,	748},
	{  571,	572,	656,	658,	748,	749},
	{  572,	573,	657,	659,	749,	750},
	{  573,	574,	658,	660,	750,	751},
	{  574,	575,	659,	661,	751,	752},// 660
	{  575,	660,	662,	752,	753,	754},
	{  575,	576,	661,	663,	754,	755},
	{  576,	577,	662,	664,	755,	756},
	{  577,	578,	663,	665,	756,	757},
	{  578,	579,	664,	666,	757,	758},
	{  579,	580,	665,	667,	758,	759},
	{  580,	581,	666,	668,	759,	760},
	{  581,	582,	667,	669,	760,	761},
	{  582,	583,	668,	670,	761,	762},
	{  583,	584,	669,	671,	762,	763},
	{  584,	585,	670,	672,	763,	764},
	{  585,	586,	671,	673,	764,	765},
	{  586,	587,	672,	674,	765,	766},
	{  587,	588,	673,	675,	766,	767},
	{  588,	589,	674,	676,	767,	768},
	{  589,	675,	677,	768,	769,	770},
	{  589,	590,	676,	678,	770,	771},
	{  590,	591,	677,	679,	771,	772},
	{  591,	592,	678,	680,	772,	773},
	{  592,	593,	679,	681,	773,	774},// 680
	{  593,	594,	680,	682,	774,	775},
	{  594,	595,	681,	683,	775,	776},
	{  595,	596,	682,	684,	776,	777},
	{  596,	597,	683,	685,	777,	778},
	{  597,	598,	684,	686,	778,	779},
	{  598,	599,	685,	687,	779,	780},
	{  599,	600,	686,	688,	780,	781},
	{  600,	601,	687,	689,	781,	782},
	{  601,	602,	688,	690,	782,	783},
	{  602,	603,	689,	691,	783,	784},
	{  603,	690,	692,	784,	785,	786},
	{  603,	604,	691,	693,	786,	787},
	{  604,	605,	692,	694,	787,	788},
	{  605,	606,	693,	695,	788,	789},
	{  606,	607,	694,	696,	789,	790},
	{  607,	608,	695,	697,	790,	791},
	{  608,	609,	696,	698,	791,	792},
	{  609,	610,	697,	699,	792,	793},
	{  610,	611,	698,	700,	793,	794},
	{  611,	612,	699,	701,	794,	795},// 700
	{  612,	613,	700,	702,	795,	796},
	{  613,	614,	701,	703,	796,	797},
	{  614,	615,	702,	704,	797,	798},
	{  615,	616,	703,	705,	798,	799},
	{  616,	617,	704,	706,	799,	800},
	{  617,	705,	707,	800,	801,	802},
	{  617,	618,	706,	708,	802,	803},
	{  618,	619,	707,	709,	803,	804},
	{  619,	620,	708,	710,	804,	805},
	{  620,	621,	709,	711,	805,	806},
	{  621,	622,	710,	712,	806,	807},
	{  622,	623,	711,	713,	807,	808},
	{  623,	624,	712,	714,	808,	809},
	{  624,	625,	713,	715,	809,	810},
	{  625,	626,	714,	716,	810,	811},
	{  626,	627,	715,	717,	811,	812},
	{  627,	628,	716,	718,	812,	813},
	{  628,	629,	717,	719,	813,	814},
	{  629,	630,	718,	720,	814,	815},
	{  547,	630,	631,	719,	815,	816},// 720
	{  631,	722,	816,	817,	818,	918},
	{  631,	632,	721,	723,	818,	819},
	{  632,	633,	722,	724,	819,	820},
	{  633,	634,	723,	725,	820,	821},
	{  634,	635,	724,	726,	821,	822},
	{  635,	636,	725,	727,	822,	823},
	{  636,	637,	726,	728,	823,	824},
	{  637,	638,	727,	729,	824,	825},
	{  638,	639,	728,	730,	825,	826},
	{  639,	640,	729,	731,	826,	827},
	{  640,	641,	730,	732,	827,	828},
	{  641,	642,	731,	733,	828,	829},
	{  642,	643,	732,	734,	829,	830},
	{  643,	644,	733,	735,	830,	831},
	{  644,	645,	734,	736,	831,	832},
	{  645,	646,	735,	737,	832,	833},
	{  646,	736,	738,	833,	834,	835},
	{  646,	647,	737,	739,	835,	836},
	{  647,	648,	738,	740,	836,	837},
	{  648,	649,	739,	741,	837,	838},// 740
	{  649,	650,	740,	742,	838,	839},
	{  650,	651,	741,	743,	839,	840},
	{  651,	652,	742,	744,	840,	841},
	{  652,	653,	743,	745,	841,	842},
	{  653,	654,	744,	746,	842,	843},
	{  654,	655,	745,	747,	843,	844},
	{  655,	656,	746,	748,	844,	845},
	{  656,	657,	747,	749,	845,	846},
	{  657,	658,	748,	750,	846,	847},
	{  658,	659,	749,	751,	847,	848},
	{  659,	660,	750,	752,	848,	849},
	{  660,	661,	751,	753,	849,	850},
	{  661,	752,	754,	850,	851,	852},
	{  661,	662,	753,	755,	852,	853},
	{  662,	663,	754,	756,	853,	854},
	{  663,	664,	755,	757,	854,	855},
	{  664,	665,	756,	758,	855,	856},
	{  665,	666,	757,	759,	856,	857},
	{  666,	667,	758,	760,	857,	858},
	{  667,	668,	759,	761,	858,	859},// 760
	{  668,	669,	760,	762,	859,	860},
	{  669,	670,	761,	763,	860,	861},
	{  670,	671,	762,	764,	861,	862},
	{  671,	672,	763,	765,	862,	863},
	{  672,	673,	764,	766,	863,	864},
	{  673,	674,	765,	767,	864,	865},
	{  674,	675,	766,	768,	865,	866},
	{  675,	676,	767,	769,	866,	867},
	{  676,	768,	770,	867,	868,	869},
	{  676,	677,	769,	771,	869,	870},
	{  677,	678,	770,	772,	870,	871},
	{  678,	679,	771,	773,	871,	872},
	{  679,	680,	772,	774,	872,	873},
	{  680,	681,	773,	775,	873,	874},
	{  681,	682,	774,	776,	874,	875},
	{  682,	683,	775,	777,	875,	876},
	{  683,	684,	776,	778,	876,	877},
	{  684,	685,	777,	779,	877,	878},
	{  685,	686,	778,	780,	878,	879},
	{  686,	687,	779,	781,	879,	880},// 780
	{  687,	688,	780,	782,	880,	881},
	{  688,	689,	781,	783,	881,	882},
	{  689,	690,	782,	784,	882,	883},
	{  690,	691,	783,	785,	883,	884},
	{  691,	784,	786,	884,	885,	886},
	{  691,	692,	785,	787,	886,	887},
	{  692,	693,	786,	788,	887,	888},
	{  693,	694,	787,	789,	888,	889},
	{  694,	695,	788,	790,	889,	890},
	{  695,	696,	789,	791,	890,	891},
	{  696,	697,	790,	792,	891,	892},
	{  697,	698,	791,	793,	892,	893},
	{  698,	699,	792,	794,	893,	894},
	{  699,	700,	793,	795,	894,	895},
	{  700,	701,	794,	796,	895,	896},
	{  701,	702,	795,	797,	896,	897},
	{  702,	703,	796,	798,	897,	898},
	{  703,	704,	797,	799,	898,	899},
	{  704,	705,	798,	800,	899,	900},
	{  705,	706,	799,	801,	900,	901},// 800
	{  706,	800,	802,	901,	902,	903},
	{  706,	707,	801,	803,	903,	904},
	{  707,	708,	802,	804,	904,	905},
	{  708,	709,	803,	805,	905,	906},
	{  709,	710,	804,	806,	906,	907},
	{  710,	711,	805,	807,	907,	908},
	{  711,	712,	806,	808,	908,	909},
	{  712,	713,	807,	809,	909,	910},
	{  713,	714,	808,	810,	910,	911},
	{  714,	715,	809,	811,	911,	912},
	{  715,	716,	810,	812,	912,	913},
	{  716,	717,	811,	813,	913,	914},
	{  717,	718,	812,	814,	914,	915},
	{  718,	719,	813,	815,	915,	916},
	{  719,	720,	814,	816,	916,	917},
	{  631,	720,	721,	815,	917,	918},
	{  721,	818,	918,	-1,	-1,	-1},
	{  721,	722,	817,	819,	-1,	-1},
	{  722,	723,	818,	820,	-1,	-1},
	{  723,	724,	819,	821,	-1,	-1},// 820
	{  724,	725,	820,	822,	-1,	-1},
	{  725,	726,	821,	823,	-1,	-1},
	{  726,	727,	822,	824,	-1,	-1},
	{  727,	728,	823,	825,	-1,	-1},
	{  728,	729,	824,	826,	-1,	-1},
	{  729,	730,	825,	827,	-1,	-1},
	{  730,	731,	826,	828,	-1,	-1},
	{  731,	732,	827,	829,	-1,	-1},
	{  732,	733,	828,	830,	-1,	-1},
	{  733,	734,	829,	831,	-1,	-1},
	{  734,	735,	830,	832,	-1,	-1},
	{  735,	736,	831,	833,	-1,	-1},
	{  736,	737,	832,	834,	-1,	-1},
	{  737,	833,	835,	-1,	-1,	-1},
	{  737,	738,	834,	836,	-1,	-1},
	{  738,	739,	835,	837,	-1,	-1},
	{  739,	740,	836,	838,	-1,	-1},
	{  740,	741,	837,	839,	-1,	-1},
	{  741,	742,	838,	840,	-1,	-1},
	{  742,	743,	839,	841,	-1,	-1},// 840
	{  743,	744,	840,	842,	-1,	-1},
	{  744,	745,	841,	843,	-1,	-1},
	{  745,	746,	842,	844,	-1,	-1},
	{  746,	747,	843,	845,	-1,	-1},
	{  747,	748,	844,	846,	-1,	-1},
	{  748,	749,	845,	847,	-1,	-1},
	{  749,	750,	846,	848,	-1,	-1},
	{  750,	751,	847,	849,	-1,	-1},
	{  751,	752,	848,	850,	-1,	-1},
	{  752,	753,	849,	851,	-1,	-1},
	{  753,	850,	852,	-1,	-1,	-1},
	{  753,	754,	851,	853,	-1,	-1},
	{  754,	755,	852,	854,	-1,	-1},
	{  755,	756,	853,	855,	-1,	-1},
	{  756,	757,	854,	856,	-1,	-1},
	{  757,	758,	855,	857,	-1,	-1},
	{  758,	759,	856,	858,	-1,	-1},
	{  759,	760,	857,	859,	-1,	-1},
	{  760,	761,	858,	860,	-1,	-1},
	{  761,	762,	859,	861,	-1,	-1},// 860
	{  762,	763,	860,	862,	-1,	-1},
	{  763,	764,	861,	863,	-1,	-1},
	{  764,	765,	862,	864,	-1,	-1},
	{  765,	766,	863,	865,	-1,	-1},
	{  766,	767,	864,	866,	-1,	-1},
	{  767,	768,	865,	867,	-1,	-1},
	{  768,	769,	866,	868,	-1,	-1},
	{  769,	867,	869,	-1,	-1,	-1},
	{  769,	770,	868,	870,	-1,	-1},
	{  770,	771,	869,	871,	-1,	-1},
	{  771,	772,	870,	872,	-1,	-1},
	{  772,	773,	871,	873,	-1,	-1},
	{  773,	774,	872,	874,	-1,	-1},
	{  774,	775,	873,	875,	-1,	-1},
	{  775,	776,	874,	876,	-1,	-1},
	{  776,	777,	875,	877,	-1,	-1},
	{  777,	778,	876,	878,	-1,	-1},
	{  778,	779,	877,	879,	-1,	-1},
	{  779,	780,	878,	880,	-1,	-1},
	{  780,	781,	879,	881,	-1,	-1},// 880
	{  781,	782,	880,	882,	-1,	-1},
	{  782,	783,	881,	883,	-1,	-1},
	{  783,	784,	882,	884,	-1,	-1},
	{  784,	785,	883,	885,	-1,	-1},
	{  785,	884,	886,	-1,	-1,	-1},
	{  785,	786,	885,	887,	-1,	-1},
	{  786,	787,	886,	888,	-1,	-1},
	{  787,	788,	887,	889,	-1,	-1},
	{  788,	789,	888,	890,	-1,	-1},
	{  789,	790,	889,	891,	-1,	-1},
	{  790,	791,	890,	892,	-1,	-1},
	{  791,	792,	891,	893,	-1,	-1},
	{  792,	793,	892,	894,	-1,	-1},
	{  793,	794,	893,	895,	-1,	-1},
	{  794,	795,	894,	896,	-1,	-1},
	{  795,	796,	895,	897,	-1,	-1},
	{  796,	797,	896,	898,	-1,	-1},
	{  797,	798,	897,	899,	-1,	-1},
	{  798,	799,	898,	900,	-1,	-1},
	{  799,	800,	899,	901,	-1,	-1},// 900
	{  800,	801,	900,	902,	-1,	-1},
	{  801,	901,	903,	-1,	-1,	-1},
	{  801,	802,	902,	904,	-1,	-1},
	{  802,	803,	903,	905,	-1,	-1},
	{  803,	804,	904,	906,	-1,	-1},
	{  804,	805,	905,	907,	-1,	-1},
	{  805,	806,	906,	908,	-1,	-1},
	{  806,	807,	907,	909,	-1,	-1},
	{  807,	808,	908,	910,	-1,	-1},
	{  808,	809,	909,	911,	-1,	-1},
	{  809,	810,	910,	912,	-1,	-1},
	{  810,	811,	911,	913,	-1,	-1},
	{  811,	812,	912,	914,	-1,	-1},
	{  812,	813,	913,	915,	-1,	-1},
	{  813,	814,	914,	916,	-1,	-1},
	{  814,	815,	915,	917,	-1,	-1},
	{  815,	816,	916,	918,	-1,	-1},
	{  721,	816,	817,	917,	-1,	-1}
  };

  for (UInt_t i=0; i<GetNumPixels(); i++)
      (*this)[i].SetNeighbors(nn[i][0], nn[i][1], nn[i][2],
                              nn[i][3], nn[i][4], nn[i][5]);

  InitOuterRing();
}
