#ifndef MARS_MHPixVsTime
#define MARS_MHPixVsTime

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TGraph
#include <TGraph.h>
#endif

class MHCamera;
class MCamEvent;
class MGeomCam;

class MHPixVsTime : public MH
{
private:
    TGraph     fGraph;
    Int_t      fIndex;

    MCamEvent *fEvt; //! the current event
    MGeomCam  *fCam; //! the camera geometry

    TString fNameEvt;

    Int_t fType;
    Int_t fTypeErr;

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

public:
    MHPixVsTime(Int_t idx=0, const char *name=NULL, const char *title=NULL);
    ~MHPixVsTime();

    void SetNameEvt(const TString name) { fNameEvt = name; }
    void SetType(Int_t type, Int_t e=-1) { fType = type; fTypeErr=e; }

    TH1 *GetHistByName(const TString name="");
    TGraph &GetGraph() { return fGraph; }

    void Draw(Option_t *o="");

    ClassDef(MHPixVsTime, 1) // Histogram to sum camera events
};

#endif
