#ifndef MARS_MHNewImagePar
#define MARS_MHNewImagePar

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHillas;

class MHNewImagePar : public MH
{
private:
    TH1F fHistLeakage1; //
    TH1F fHistLeakage2; //

    TH1F fHistUsedPix;  // Number of used pixels
    TH1F fHistCorePix;  // Number of core pixels

    TH1F fHistConc;     // [ratio] concentration ratio: sum of the two highest pixels / fSize
    TH1F fHistConc1;    // [ratio] concentration ratio: sum of the highest pixel / fSize

public:
    MHNewImagePar(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1 *GetHistByName(const TString name);

    TH1F &GetHistLeakage1() { return fHistLeakage1; }
    TH1F &GetHistLeakage2() { return fHistLeakage2; }

    TH1F &GetHistUsedPix()  { return fHistUsedPix; }
    TH1F &GetHistCorePix()  { return fHistCorePix; }

    TH1F &GetHistConc()     { return fHistConc; }
    TH1F &GetHistConc1()    { return fHistConc1; }

    void Draw(Option_t *opt=NULL);

    ClassDef(MHNewImagePar, 1) // Histograms of new image parameters
};

#endif


