#ifndef MAGIC_H
#define MAGIC_H
///////////////////////////////////////////////////////////////////////////////
//
//     Magic.h
//
//     defines MAGIC base informations
//
///////////////////////////////////////////////////////////////////////////////

#include <TROOT.h>

//
// Magic number to detect the magic file type
//
const UShort_t kMagicNumber = 0xc0c0;

//
// Values for the eventloop control
//
const Int_t kCONTINUE = 2;

//
//     Number of the Pixels in the Camera
//
const Int_t kCAMERA_PIXELS = 577;

//
//     Number of the Slices of one Fadc. Be carefull this is the number of 
//     slices for one gain branch. We sample two times this number. 
//
const Int_t kFADC_SLICES   = 15;

//
//     ParticleId for Monte Carlo simulation
//
const Int_t kGAMMA  =    0;
const Int_t kPROTON =   14;
const Int_t kHELIUM =  402;
const Int_t kOXIGEN = 1608;
const Int_t kIRON   = 5626;

//
// nummber of ADC conversions per pixel
//
const Int_t kMAX_ADC = 30;

//
//camera dimensions and definitions
//
const Float_t kPIXEL_DIST       =  10.0;	//cm
const Int_t   kCAMERA_COLOR     =  13;   	//Background light grey
const Int_t   kDEFAULT_COLOR    =   1;   	//black
const Int_t   kPIXEL_LINE_COLOR =  15;	        //dark grey
const Int_t   kCOLORTABLE_START =  18;	        //Begin of colortable
const Int_t   kMAX_PH_EL        = 500;   	//upper limit for colortable

//
// THE MAGIC RUNTIME DATABASE
//
//class MRuntimeDb;
//extern MRuntimeDb *gMagic;

#endif
