#ifndef MARS_MRawFileWrite
#define MARS_MRawFileWrite

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TFile;
class TTree;

class MTime;
class MParList;
class MRawRunHeader;
class MRawEvtHeader;
class MRawCrateArray;
class MRawEvtData;

class MRawFileWrite : public MTask
{
private:
    MParList *pParList;

    MTime          *fRawEvtTime;
    MRawRunHeader  *fRawRunHeader;
    MRawEvtHeader  *fRawEvtHeader;
    MRawEvtData    *fRawEvtData;
    MRawCrateArray *fRawCrateArray;

    TTree *fTData;                  //!
    TTree *fTPedestal;              //!
    TTree *fTCalibration;           //!

    TFile *fOut;                    //!

public:
    MRawFileWrite(const char *fname,
                  const Option_t *opt="RECREATE",
                  const char *ftitle="Untitled",
                  const Int_t comp=1,
                  const char *name=NULL, const char *title=NULL);
    ~MRawFileWrite();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    ClassDef(MRawFileWrite, 0)	// Task to write the raw data containers to a root file
};

#endif
