#ifndef MARS_MRawSocketRead
#define MARS_MRawSocketRead

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef __IOSFWD__
#include <iosfwd>
#endif

class MTime;
class MParList;
class MReadSocket;
class MRawEvtData;
class MRawEvtHeader;
class MRawRunHeader;
class MRawCrateArray;

class MRawSocketRead : public MTask
{
private:
    MRawRunHeader  *fRawRunHeader;  // run header information container to fill from file
    MRawEvtHeader  *fRawEvtHeader;  // event header information container to fill from file
    MRawEvtData    *fRawEvtData;    // raw evt header infomation container to fill from file
    MRawCrateArray *fRawCrateArray; // crate information array container to fill from file
    MTime          *fRawEvtTime;    // raw evt time information container to fill from file

    MReadSocket    *fIn;            //! buffered input stream (file to read from)
    MParList       *fParList;       //!

    UInt_t          fRunNumber;     //!
    UInt_t          fEvtNumber;     //!

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MRawSocketRead(const char *name=NULL, const char *title=NULL);
    ~MRawSocketRead();

    ClassDef(MRawSocketRead, 0)	//Task to read DAQ binary data from tcp/ip socket
};

#endif
