#ifndef MARS_MPedestalPix
#define MARS_MPedestalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPedestalPix : public MParContainer
{
private:
    Float_t fPedestal;     // mean value of pedestal (PMT offset)
    Float_t fPedestalRms;  // root mean square / sigma  / standard deviation of pedestal

public:
    MPedestalPix();

    void Clear(Option_t *o="");

    Float_t GetPedestal() const    { return fPedestal; }
    Float_t GetPedestalRms() const { return fPedestalRms; }
/*
    void SetMean(Float_t f)     { fMean = f;     }
    void SetSigma(Float_t f)    { fSigma = f;    }
    void SetMeanRms(Float_t f)  { fMeanRms = f;  }
    void SetSigmaRms(Float_t f) { fSigmaRms = f; }
    */

    void SetPedestal(Float_t f)    { fPedestal = f; }
    void SetPedestalRms(Float_t f) { fPedestalRms = f; }
    void Set(Float_t m, Float_t r) { fPedestal = m; fPedestalRms = r; }

    Bool_t IsValid() const { return fPedestal>=0||fPedestalRms>=0; }

    ClassDef(MPedestalPix, 1)	// Storage Container for Pedestal information of one pixel
};

#endif

