#ifndef MARS_MH2dimFunction
#define MARS_MH2dimFunction

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHillas;

class MH2dimFunction : public MH
{
private:

    TH1F fHistXbarYbar; // position where shower image has its maximum
    TH1F fHistAmp;      // amplitude of shower image
    TH1F fHistMajor;    // 'length' of shower image
    TH1F fHistMinor;    // 'width' of shower image
    TH1F fHistAsym;     // 'asymmetry' of shower image


public:
    MH2dimFunction(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1F &GetHistXbarYbar() { return fHistXbarYbar; }
    TH1F &GetHistAmp()      { return fHistAmp; }

    TH1F &GetHistMajor()    { return fHistMajor; }
    TH1F &GetHistMinor()    { return fHistMinor; }

    TH1F &GetHistAsym()     { return fHistAsym; }

    void Draw(Option_t *opt=NULL);

    ClassDef(MH2dimFunction, 1) // Histograms of parameters of 2-dim function
};

#endif




