/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 4/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  Status - Example how to use the MStatusDisplay
//
//  Use a camera file as input
//
/////////////////////////////////////////////////////////////////////////////

#include "MStatusDisplay.h"
#include "MLog.h"
#include "MParList.h"
#include "MTaskList.h"
#include "MReadMarsFile.h"
#include "MGeomApply.h"
#include "MMcPedestalCopy.h"
#include "MMcPedestalNSBAdd.h"
#include "MCerPhotAnal2.h"
//#include "MBlindPixelCalc.h"
#include "MSigmabarCalc.h"
#include "MImgCleanStd.h"
#include "MHillasCalc.h"
#include "MHillasSrcCalc.h"
#include "MCT1SupercutsCalc.h"
#include "MHCamEvent.h"
#include "MFillH.h"
#include "MEvtLoop.h"

#include <TApplication.h>


int main(int argc, char **argv)
{
    TApplication app("Status", &argc, argv);


    //
    // Update frequency by default = 1Hz
    //
    MStatusDisplay *d = new MStatusDisplay;

    // Set update time to 5s
    // d->SetUpdateTime(5000);

    // Disable online update
    // d->SetUpdateTime(-1);

    d->SetLogStream(&gLog, kTRUE);            // Disables output to stdout
    gLog.SetOutputFile("status.log", kTRUE);  // Enable output to file
    //gLog.EnableOutputDevice(MLog::eStdout); // Enable output to stdout again

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    /*
     MSrcPosCam src;
     src.SetXY(1./geomcam.GetConvMm2Deg(), 0);
     plist.AddToList(&src);
     */

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");
    read.DisableAutoScheme();

    // ------------- user change -----------------
    read.AddFile("/home/tbretz/cosmics.root");

    MGeomApply        geomapl;

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotAnal2     ncalc;
/*
    TArrayS blinds(6);
    blinds[0] =   0;
    blinds[1] = 195;
    blinds[2] = 227;
    blinds[3] = 248;
    blinds[4] = 271;
    blinds[5] = 291;
    /*
     blinds[3] =  51;
     blinds[4] =  56;
     blinds[5] = 112;//*
     blinds[6] =  31;//*
     blinds[7] = 116;
     blinds[8] = 507;
     blinds[9] = 559;
     blinds[10]= 291; // 311, 119, 54, 85, 125, 92, 133, 224*/
/*
    MBlindPixelCalc blind;
    blind.SetPixelIndices(blinds);
    //blind.SetUseInterpolation();
*/
    MSigmabarCalc     sgcal;
    MImgCleanStd      clean;
    MHillasCalc       hcalc;
    MHillasSrcCalc    scalc; // !!Preliminary!! Will be removed later!
    MCT1SupercutsCalc calc1;

    MHCamEvent hist("PedestalRms");
    hist.SetType(1);
    plist.AddToList(&hist);

    // -------------------------------------------
    MFillH hfill0("Uncleaned [MHCamEvent]", "MCerPhotEvt");
    MFillH hfill1("Pedestals [MHCamEvent]", "MPedestalCam");
    MFillH hfill2("PedestalRms", "MPedestalCam");
    MFillH hfill3("MHHillas", "MHillas");
    MFillH hfill4("MHHillasExt");
    MFillH hfill5("MHHillasExtSrc [MHHillasExt]", "MHillasSrc");
    MFillH hfill6("MHHillasSrc","MHillasSrc");
    MFillH hfill7("MHNewImagePar","MNewImagePar");
    MFillH hfill8a("MHStarMap", "MHillas");
    MFillH hfill8b("MHStarMap2", "MHillas");
    MFillH hfill9("Cleaned [MHCamEvent]", "MCerPhotEvt");
    MFillH hfill10("MHHadronness", "MHadronness");
    MFillH hfill11("MHSigmaTheta");

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    //tlist.AddToList(&blind);
    tlist.AddToList(&hfill0);
    //tlist.AddToList(&sgcal);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&scalc);
    //tlist.AddToList(&calc1);
    tlist.AddToList(&hfill1);
    tlist.AddToList(&hfill2);
    tlist.AddToList(&hfill3);
    tlist.AddToList(&hfill4);
    tlist.AddToList(&hfill5);
    tlist.AddToList(&hfill6);
    tlist.AddToList(&hfill7);
    //tlist.AddToList(&hfill8a);
    //tlist.AddToList(&hfill8b);
    tlist.AddToList(&hfill9);
    //tlist.AddToList(&hfill10);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);
    evtloop.SetDisplay(d);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return 1;

    tlist.PrintStatistics();

    return 0;
}
