##################################################################
#           
#   makefile
# 
#   for the MARS software
#
##################################################################

#.SILENT:

.SUFFIXES: .c .cc .cxx .h .hxx .o 

SRCS    = $(SRCFILES)
HEADERS = $(SRCFILES:.cc=.h)
OBJS    = $(SRCFILES:.cc=.o)

all: $(LIB)

depend:
	@makedepend $(SRCS) $(INCLUDES) -fMakefile 2> kk.kk ; cat kk.kk

$(LIB):  $(OBJS) BaseCint.o
	@echo "Linking $(LIB) ..."
	ar -r -c $(LIB) *.o

BaseCint.cc:	$(HEADERS)
		@echo $(HEADERS)
		@echo 
	       	@echo "Generating dictionary BaseCint.cc"

		@$(ROOTSYS)/bin/rootcint \
		-f BaseCint.cc -c $(INCLUDES) $(HEADERS) BaseLinkDef.h 

.cxx.o:	
	@echo "Compiling " $<
	$(CXX) $(CXXFLAGS) -c $< -o $@

.cc.o:	
	@echo "Compiling " $<
	$(CXX) $(CXXFLAGS) -c $< -o $@

.c.o:	
	@echo "Compiling " $<
	$(CC) $(CFLAGS) -c $< -o $@

lclean:
	@echo "Cleanning..."
	@rm -f *.o core libmbase.a

clean:
	@echo "Cleanning..."
	@rm -f $(SOLIB) $(OBJS) core 
	@rm -f MCint.cc MCint.h MCint.o

mrproper: clean
	@echo "Mr.Proper in action . . ."
	@rm -f $(PROGRAM)
	@rm -f $(SOLIB)
	@rm -f *~
	@rm -f kk.kk
	@rm -rf html

ctags:
	@echo "Creating CTAGS file . . ."
	@ctags -txw $(SRCS) $(HEADERS) > CTAGS

etags:
	@echo "Creating TAGS file . . ."
	@etags -C $(SRCS) $(HEADERS)

listsrc:
	@ls -m $(SRCS) $(HEADERS) | sed 's/,//g'

redo: clean all

cflags: 
	@echo $(INCLUDES) $(CXXFLAGS)

