/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Oscar Blanch    12/2001 <mailto:blanch@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MBlindPixel                                                             //
//                                                                         //
// If you want to exclude pixels from the analysis (eg. hillas parameter   //
// calculation) you can use this container to switch off the pixels by Id  //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MBlindPixels.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

ClassImp(MBlindPixels);

// --------------------------------------------------------------------------
//
// Default constructor.
//
MBlindPixels::MBlindPixels(const char *name, const char *title) : fPixels(577)

{
    fName  = name  ? name  : "MBlindPixels";
    fTitle = title ? title : "Container which have a list of blind pixels";
}

// -------------------------------------------------------------------------
//
// If you don't want to use pixel with Id id call
//    SetPixelBlind(id, kTRUE)
// otherwise
//    SetPixelBlind(id, kFALSE)
//
void MBlindPixels::SetPixelBlind(UShort_t id, Bool_t val)
{
    fPixels.AddAt(val, id);
}

