#ifndef MHISTOSTDC_H
#define MHISTOSTDC_H

#include "Magic.h"

#include <TObjArray.h>

#include "MParContainer.h"

class MHistosTdc : public MParContainer
{
private:
    TObjArray *fHistHigh;	// List of High gain Histograms
    TObjArray *fHistLow;	// List of Low  gain Histograms

public:
     MHistosTdc();
    ~MHistosTdc();

    void FillTdcHist(Int_t iPix, UChar_t * data);
    void SaveHist(char *name);

    void Print(Option_t * t = NULL);


    TObjArray* GetHighList() 
      { 
	return ( fHistHigh ) ; 
      } 
    
    Int_t GetHighEntries() 
      { 
	return (fHistHigh->GetEntries() ) ;  
      } 

    Int_t GetLowEntries() 
      { 
	return (fHistLow->GetEntries() ) ;  
      } 
      
    ClassDef(MHistosTdc, 1)	// list of Histograms with Tdc spectra
};

#endif

