/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug, 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

void calibration(TString pedname="./20031102_02399_P_Unavailable_E.root", 
             TString calname="./20031102_02400_D_Flip500Hz_E.root")
{
    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist for the pedestals:
    // ---------------------------------------------------
    //

    MReadMarsFile read("Events", pedname);
    read.DisableAutoScheme();

    MGeomApply geomapl;
    MPedCalcPedRun pedcalc;
    //    MPedestalCam   pedcam;

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&pedcalc);

    //    plist.AddToList(&pedcam);

    MHCamEvent hist;
    hist.SetType(1);
    plist.AddToList(&hist);
    MFillH fill("MHCamEvent", "MPedestalCam");

    tlist.AddToList(&fill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute first analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    // plist.FindObject("MPedestalCam")->Print();

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist2;

    MTaskList tlist2;
    plist2.AddToList(&tlist2);

    plist2.AddToList((MPedestalCam*)plist.FindObject("MPedestalCam"));

    MGeomApply geomapl2;
    tlist2.AddToList(&geomapl2);

    //
    // Now setup the new tasks and tasklist for the calibration
    // ---------------------------------------------------
    //

    MReadMarsFile read2("Events", calname);
    read2.DisableAutoScheme();

    MCalibrationCalc calcalc;
    calcalc.SetSkipTFits();
    //
    // As long, as we don't have digital modules, 
    // we have to set the color by hand
    //
    calcalc.SetPulserColor(MCalibrationCalc::kEBlue);

    tlist2.AddToList(&read2);
    tlist2.AddToList(&calcalc);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop2;
    evtloop2.SetParList(&plist2);

    //
    // Execute second analysis
    //
    if (!evtloop2.Eventloop())
        return;

    tlist2.PrintStatistics();

    plist2.FindObject("MCalibrationCam")->Print();
    //
    // just one example how to get the plots of individual pixels
    //
    MCalibrationCam *cam = plist2.FindObject("MCalibrationCam");
    MCalibrationPix *pix = cam->GetCalibrationPix(560);
    pix->Draw();

    /* 
    TCanvas *c = MH::MakeDefCanvas();
    c->Divide(3, 2);

    MHCamEvent &h = *(MHCamEvent*)plist->FindObject("MHCamEvent");
    MHCamera *disp0 = h.GetHistByName();
    MHCamera *disp1 = new MHCamera(geom, "MPedestalCam;avg", "Pedestals Avarage");
    MHCamera *disp2 = new MHCamera(geom, "MPedestalCam;rms", "Pedestals Avarage Error");
    MHCamera *disp3 = new MHCamera(geom, "MPedestalCam;rel", "Pedestals Avarage ERR/VAL");
    disp1->SetBit(kCanDelete);
    disp2->SetBit(kCanDelete);
    disp3->SetBit(kCanDelete);

    disp1->SetCamContent(*disp0, 0);
    disp2->SetCamContent(*disp0, 1);
    disp3->SetCamContent(*disp0, 2);

    disp1->SetYTitle("P [au]");
    disp2->SetYTitle("\\sigma_{P} [au]");
    disp3->SetYTitle("\\sigma_{P} [%]");

    TText text(0.1, 0.5, &fname[fname.Last('/')+1]);
    text.SetTextSize(0.015);
    text.DrawClone();

    c->cd(1);
    gStyle->SetOptStat(1111);
    disp1->Draw("hist");
    gPad->Update();

    c->cd(2);
    gStyle->SetOptStat(1101);
    disp2->Draw("hist");
    gPad->Update();

    c->cd(3);
    gStyle->SetOptStat(1101);
    disp3->Draw("hist");
    gPad->Update();

    c->cd(4);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    disp1->Draw();

    c->cd(5);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    disp2->Draw();

    c->cd(6);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    disp3->Draw();

    c->SaveAs(fname(0, fname.Last('.')+1) + "ps");
    //c->SaveAs(fname(0, fname.Last('.')+1) + "root");

    */

}

