#ifndef COSY_MCeCoCom
#define COSY_MCeCoCom

#ifndef ROOT_TString
#include <TString.h>
#endif

#ifndef COSY_MTcpIpIO
#include "MTcpIpIO.h"
#endif

#ifndef COSY_Timer
#include "timer.h"
#endif

class MCeCoCom : public MTcpIpIO
{
private:
    enum ComStatus_t
    {
        kCmdReceived,
        kNoCmdReceived,
        kComProblem
    };

    TString fCommand;     // report string of the current system
    Timer   fT;           // time of last report received
    char    fStatus;      // current status of this system
    int     fCCStatus;    // global status of CC

    ComStatus_t fComStat; // communication status

    Float_t fHumidity;       // [%]
    Float_t fTemperature;    // [deg] celsius
    Float_t fWindSpeed;      // [km/h]
    Float_t fSolarRadiation; // [W/m^2] IR-Radiation

    virtual bool InterpreteCmd(TString cmd, TString str);

    bool InterpreteReport(TString &str);
    bool InterpreteStr(TString str);

public:
    MCeCoCom::MCeCoCom(const char *cmd, MLog &out=gLog)
        : MTcpIpIO(out), fCommand(cmd), fStatus(0), fComStat(kNoCmdReceived)
    {
    }

    bool Send(const char *str);
    void SetStatus(Byte_t s) { fStatus=s; }

    Float_t GetHumidity() const { return fHumidity; }
    Float_t GetTemperature() const { return fTemperature; }
};

#endif
