#ifndef MARS_MCameraCooling
#define MARS_MCameraCooling

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCameraCooling : public MParContainer
{
    friend class MReportCamera;
private:
    Byte_t  fStatus;              // Monitored status: 0-8, Cam.COOLING_state

    Bool_t  fStatusPressureHi;    // 0=ok,  1=Obstruct
    Bool_t  fStatusPressureLo;    // 0=ok,  1=leakage
    Bool_t  fStatusPumb;          // 0=off, 1=on
    Bool_t  fStatusRefrigrerator; // 0=off, 1=on
    Bool_t  fStatusValve;         // 0=recirculate, 1=new
    Bool_t  fStatusResistor;      // 0=off, 1=on
    Bool_t  fStatusFans;          // 0=off, 1=on

    Float_t fTempCenter;          // [deg C] Temperature at the camera center
    Float_t fTempWall;            // [deg C] Temperature at the camera wall
    Float_t fTempOptLink;         // [deg C] Temperature at the optical link
    Float_t fTempWater;           // [deg C] Temperature of the water

    Byte_t  fHumAll;              // [%] Relative humidity over all
    Byte_t  fHumCenter;           // [%] Relative humidity camera center

public:
    ClassDef(MCameraCooling, 0)
};

#endif
