#ifndef MARS_MGeomMirror
#define MARS_MGeomMirror

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MGeomMirror : public MParContainer
{
private:
    Int_t   fMirrorId;    // the Mirror Id

    Float_t fFocalDist;   //  focal distance of that mirror [cm]
    Float_t fSX;          // curvilinear coordinate of mirror's center in X[cm]
    Float_t fSY;          // curvilinear coordinate of mirror's center in X[cm]
    Float_t fX;           // x coordinate of the center of the mirror [cm]
    Float_t fY;           // y coordinate of the center of the mirror [cm]
    Float_t fZ;           // z coordinate of the center of the mirror [cm]
    Float_t fThetaN;      // polar theta angle of the direction 
                          //  where the mirror points to
    Float_t fPhiN;        // polar phi angle of the direction
                          // where the mirror points to
    Float_t fXN;          // xn coordinate of the normal vector
                          // in the center
    Float_t fYN;          // yn coordinate of the normal vector
                          // in the center
    Float_t fZN;          // zn coordinate of the normal vector
                          // in the center
                          // Note: fXN^2*fYN^2*fZN^2 = 1
    Float_t fDeviationX;  // deviation in x [cm]
    Float_t fDeviationY;  // deviation in y [cm]
                          // of the spot of a single mirror on the camera plane
    TArrayF fWavelength;  // List of wavelength
    TArrayF fReflectivity;// Mirror reflectivity

public:
    MGeomMirror(Int_t mir=-1, const char *name=NULL, const char *title=NULL);

    Int_t GetMirrorId() const         { return fMirrorId;   }

    void  SetMirrorContent(Int_t mir, Float_t focal, Float_t curv_x,
                           Float_t curv_y, Float_t lin_x, Float_t lin_y,
                           Float_t lin_z, Float_t theta, Float_t phi,
                           Float_t x_n, Float_t y_n, Float_t z_n);
    void  SetMirrorDeviations(Float_t dev_x, Float_t dev_y);

    void  SetReflectivity(const TArrayF &wav, const TArrayF &ref);

    void    SetArraySize(Int_t dim) { fWavelength.Set(dim); fReflectivity.Set(dim); }

    ClassDef(MGeomMirror, 2)  // geometry class describing one mirror
};

#endif


