#ifndef MARS_M2dimFunction
#define MARS_M2dimFunction

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class M2dimFunction : public MParContainer
{
private:

  // free parameters of the 2-dim function describing the shower image
  Double_t fXbar, fYbar;      // position where shower image has its maximum
  Double_t fDelta;            // angle between shower axis and x-axis
  Double_t fAmp;              // amplitude of shower image
  Double_t fMajor; fMinor;    // parameters describing the extension of
                              // the shower along and perpendicular 
                              // to the shower axis
  Double_t fAsym;             // parameter describing the asymmetry along the
                              // shower axis

  TVectorD Vinit;             // initial values of the parameters

public:
    M2dimFunction(const char *name=NULL, const char *title=NULL);

    void SetVinit(MHillas *fhillas);

    Fit();

    ClassDef(M2dimFunction, 1) // Container to hold the parameters of the 
                               // 2-dim function describing the shower image
};

#endif



























