/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

void readMagic(const char *fname="../Proton*.root")
{
    MParList plist;

    MHillas       hillas;
    MHillasExt    hillasext;
    MNewImagePar  newimgpar;
    MTaskList     tlist;

    plist.AddToList(&hillas);
    plist.AddToList(&hillasext);
    plist.AddToList(&newimgpar);
    plist.AddToList(&tlist);

    MReadMarsFile read("Events", fname);
    read.DisableAutoScheme();

    MGeomApply geomapl;
    MPrint print1("MMcEvt");
    MPrint print2("MRawEvtHeader");
    print1.EnableSkip();
    print2.EnableSkip();

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotCalc      ncalc;
    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();
    MClone            clone("MCerPhotEvt");
    MImgCleanStd      clean;
    MHillasCalc       hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&print1);
    tlist.AddToList(&print2);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&blind);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MGeomCam *geomcam = (MGeomCam*)plist->FindObject("MGeomCam");

    MHCamera display1(*geomcam);
    MHCamera display2(*geomcam);

    TCanvas c("Events", "Real Events", 300, 600);
    c.SetBorderMode(0);
    c.Divide(1,2);
    c.cd(1);
    display1.Draw();
    gPad->cd(1);
    hillas.Draw();
    c.cd(2);
    display2.Draw();
    gPad->cd(1);
    hillas.Draw();

    // Use this if you don't want the event to be autoscaled
    //display.SetMinimum(0);
    //display.SetMaximum(100);

    while (tlist.Process())
    {
        cout << "Event #" << read.GetNumEntry() ":" << endl;

        display1.SetCamContent(*(MCerPhotEvt*)clone.GetClone());
        display2.SetCamContent(*(MCerPhotEvt*)plist.FindObject("MCerPhotEvt"));

        c->GetPad(1)->GetPad(1)->Modified();
        c->GetPad(1)->GetPad(1)->Update();
        c->GetPad(2)->GetPad(1)->Modified();
        c->GetPad(2)->GetPad(1)->Update();

        hillas.Print();
        hillasext.Print();
        newimgpar.Print();

        if (!HandleInput())
            break;
    }

    evtloop.PostProcess();
}

