#ifndef MARS_MReportCamera
#define MARS_MReportCamera

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MCameraCooling;
class MCameraLids;
class MCameraHV;
class MCameraLV;
class MCameraCalibration;

class MReportCamera : public MReport
{
private:
    Byte_t fStatus;   // CaCo monitored status of the sentinel (0-9), Sentinel_state
    Byte_t fStatusDC; // CaCo monitored status of the DC currents (0-9), Cam.DC_state

    MCameraCooling     *fCooling;
    MCameraLids        *fLids;
    MCameraHV          *fHV;
    MCameraLV          *fLV;
    MCameraCalibration *fCalibration;

    Bool_t SetupReading(MParList &plist);
    Bool_t CheckTag(TString &str, const char *tag) const;

    Bool_t InterpreteDC(TString &str);
    Bool_t InterpreteHV(TString &str);
    Bool_t InterpreteCOOL(TString &str);
    Bool_t InterpreteLID(TString &str);
    Bool_t InterpreteHVPS(TString &str);
    Bool_t InterpreteLV(TString &str);
    Bool_t InterpreteAUX(TString &str);
    Bool_t InterpreteCAL(TString &str);

public:
    MReportCamera();

    Bool_t InterpreteBody(TString &str);

    ClassDef(MReportCamera, 1) // Base class for control reports
};

#endif
