/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug, 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

void calibration(TString pedname="./20031102_02399_P_Unavailable_E.root", 
                 TString calname="./20031102_02400_D_Flip500Hz_E.root")
{

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist for the pedestals:
    // ---------------------------------------------------
    //

    MReadMarsFile read("Events", pedname);
    read.DisableAutoScheme();

    MGeomApply     geomapl;
    MGeomCamMagic  geomcam;
    MGeomCam       geom;
    MPedCalcPedRun pedcalc;
    MPedestalCam   pedcam;

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&pedcalc);

    plist.AddToList(&pedcam);

    MHCamEvent hist("Pedestal");
    hist.SetType(1);
    plist.AddToList(&hist);
    MFillH fill(&hist, "MPedestalCam");

    tlist.AddToList(&fill);

    //
    // Update frequency by default = 1Hz
    //
    MStatusDisplay *d = new MStatusDisplay;
 
    // Set update time to 3s
    d->SetUpdateTime(3000);
 
    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);
    evtloop.SetDisplay(d);  	

    //
    // Execute first analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    //
    // Create a empty Parameter List and an empty Task List
    //
    MParList  plist2;

    MTaskList tlist2;
    plist2.AddToList(&tlist2);

    plist2.AddToList((MPedestalCam*)plist.FindObject("MPedestalCam"));

    MGeomApply geomapl2;
    tlist2.AddToList(&geomapl);

    //
    // Now setup the new tasks and tasklist for the calibration
    // ---------------------------------------------------
    //

    MReadMarsFile read2("Events", calname);
    read2.DisableAutoScheme();

    MCalibrationCalc calcalc;
    calcalc.SetSkipTFits();

    plist2.AddToList(&geomcam);

    //
    // As long, as we don't have digital modules, 
    // we have to set the color by hand
    //
    calcalc.SetPulserColor(MCalibrationCalc::kEBlue);

    tlist2.AddToList(&read2);
    tlist2.AddToList(&calcalc);

    MHCamEvent hist2;
    hist2.SetType(0);
    plist2.AddToList(&hist2);
    MFillH fill2("MHCamEvent", "MCalibrationCam");
    tlist2.AddToList(&fill2);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop2;
    evtloop2.SetParList(&plist2);

    //
    // Execute second analysis
    //
    if (!evtloop2.Eventloop())
        return;

    tlist2.PrintStatistics();

 //   plist2.FindObject("MCalibrationCam")->Print();

    //
    // just one example how to get the plots of individual pixels
    //
    MCalibrationCam *cam = plist2.FindObject("MCalibrationCam");
    MCalibrationPix *pix = cam->GetCalibrationPix(523);
    //pix->Draw();

    gROOT->GetListOfCanvases()->Delete();

    MHCamEvent &h    = *(MHCamEvent*)plist2->FindObject("MHCamEvent");
    MHCamera &disp0  = *h.GetHistByName();
    MHCamera disp1   (geomcam, "MCalibrationCam;q", "Fitted Mean Charges");
    MHCamera disp2   (geomcam, "MCalibrationCam;errq", "Error of Fitted Mean Charges");
    MHCamera disp3   (geomcam, "MCalibrationCam;sigmaq", "Sigma of Fitted Mean Charges");
    MHCamera disp4   (geomcam, "MCalibrationCam;errsigmaq", "Error of Sigma of Fitted Mean Charges");
    MHCamera disp5   (geomcam, "MCalibrationCam;probq", "Probability of Fit");
    MHCamera disp6   (geomcam, "MCalibrationCam;t", "Arrival Times");
    MHCamera disp7   (geomcam, "MCalibrationCam;sigmat", "Sigma of Arrival Times");
    MHCamera disp8   (geomcam, "MCalibrationCam;probt", "Probability of Time Fit");
    MHCamera disp9   (geomcam, "MCalibrationCam;ped", "Pedestals");
    MHCamera disp10  (geomcam, "MCalibrationCam;pedrms", "Pedestal RMS");
    MHCamera disp11  (geomcam, "MCalibrationCam;rq", "Reduced Charges");
    MHCamera disp12  (geomcam, "MCalibrationCam;errrq", "Error of Reduced Charges");

    disp1.SetCamContent(*cam, 0);
    disp2.SetCamContent(*cam, 1);
    disp3.SetCamContent(*cam, 2);
    disp4.SetCamContent(*cam, 3);
    disp5.SetCamContent(*cam, 4);
    disp6.SetCamContent(*cam, 5);
    disp7.SetCamContent(*cam, 6);
    disp8.SetCamContent(*cam, 7);
    disp9.SetCamContent(*cam, 8);
    disp10.SetCamContent(*cam, 9);
    disp11.SetCamContent(*cam, 10);
    disp12.SetCamContent(*cam, 11);

    disp1.SetYTitle("Q [FADC counts]");
    disp2.SetYTitle("\\Delta_{Q} [FADC counts]");
    disp3.SetYTitle("\\sigma_{Q} [FADC counts]");
    disp4.SetYTitle("\\Delta_{\\sigma_{Q}} [FADC counts]");
    disp5.SetYTitle("P [au]");
    disp6.SetYTitle("T [FADC slices]");
    disp7.SetYTitle("\\Delta_{T} [FADC slices]");
    disp8.SetYTitle("P [au]");
    disp9.SetYTitle("P [FADC counts/ slice ]");
    disp10.SetYTitle("RMS_{P} [FADC counts / slice ]");
    disp11.SetYTitle("Q [FADC counts]");
    disp12.SetYTitle("\\Delta_{Q} [FADC counts]");

//    TText text(0.1, 0.5, &fname[fname.Last('/')+1]);
//    text.SetTextSize(0.015);
//    text.DrawClone();
    TCanvas *c1 = &d->AddTab("Cal1");//MH::MakeDefCanvas("Calibration1","Plots of FADC Charges",700,900);
    c1->Divide(5, 2);

    TObject *obj;

    c1->cd(1);
    gStyle->SetOptStat(1111);
    obj=disp1.DrawCopy("hist");

    c1->cd(6);
    gPad->SetBorderMode(0);
    obj->Draw();

    c1->cd(2);
    gStyle->SetOptStat(1101);
    obj=disp2.DrawCopy("hist");

    c1->cd(7);
    gPad->SetBorderMode(0);
    obj->Draw();

    c1->cd(3);
    gStyle->SetOptStat(1101);
    obj=disp3.DrawCopy("hist");

    c1->cd(8);
    gPad->SetBorderMode(0);
    obj->Draw();

    c1->cd(4);
    gStyle->SetOptStat(1101);
    obj=disp4.DrawCopy("hist");

    c1->cd(9);
    gPad->SetBorderMode(0);
    obj->Draw();

    c1->cd(5);
    gStyle->SetOptStat(1101);
    obj=disp5.DrawCopy("hist");

    c1->cd(10);
    gPad->SetBorderMode(0);
    obj->Draw();

    TCanvas *c2 = &d->AddTab("Cal2");//MH::MakeDefCanvas("Calibration2","Plots of Arrival Times",700,900);
    c2->Divide(3, 2);

    c2->cd(1);
    gStyle->SetOptStat(1111);
    obj=disp6.DrawCopy("hist");

    c2->cd(4);
    obj->Draw();

    c2->cd(2);
    gStyle->SetOptStat(1101);
    obj=disp7.DrawCopy("hist");

    c2->cd(5);
    obj->Draw();

    c2->cd(3);
    gStyle->SetOptStat(1101);
    obj=disp8.DrawCopy("hist");

    c2->cd(6);
    obj->Draw();

    TCanvas *c3 = &d->AddTab("Cal3");//MH::MakeDefCanvas("Calibration3","Plots of Pedestals",700,900);
    c3->Divide(2, 2);

    c3->cd(1);
    gStyle->SetOptStat(1111);
    obj=disp9.DrawCopy("hist");

    c3->cd(3);
    obj->Draw();

    c3->cd(2);
    gStyle->SetOptStat(1101);
    obj=disp10.DrawCopy("hist");

    c3->cd(4);
    obj->Draw();

    TCanvas *c4 = &d->AddTab("Cal4");//MH::MakeDefCanvas("Calibration4","Plots of Reduced Charges",700,900);
    c4->Divide(2, 2);

    c4->cd(1);
    gStyle->SetOptStat(1111);
    obj=disp11.DrawCopy("hist");

    c4->cd(3);
    obj->Draw();

    c4->cd(2);
    gStyle->SetOptStat(1101);
    obj=disp12.DrawCopy("hist");

    c4->cd(4);
    obj->Draw();

//    c->SaveAs(fname(0, fname.Last('.')+1) + "ps");
    //c->SaveAs(fname(0, fname.Last('.')+1) + "root");

}

