#ifndef MARS_MHCalibrationBlindPixel
#define MARS_MHCalibrationBlindPixel

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MHCalibrationConfig
#include "MHCalibrationConfig.h"
#endif

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1F
#include "TH1F.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

#ifndef ROOT_TPaveText
#include "TPaveText.h"
#endif

class TMath;
class MParList;
class MHCalibrationBlindPixel : public MH
{
private:

  TH1I* fHBPQ;        //-> Histogram with the single Phe spectrum
  TH1F* fHBPErrQ;     //-> Variance of summed FADC slices
  TH1I* fHBPT;        //-> Variance of summed FADC slices
  TH1I* fHBPQvsN;     //-> Summed Charge vs. Event Nr. 
  
  TF1 *fSinglePheFit;
  TF1 *fTimeGausFit;  

  Axis_t  fBPQfirst;
  Axis_t  fBPQlast;
  Int_t   fBPQnbins;
  
  Axis_t fErrBPQfirst;
  Axis_t fErrBPQlast;
  Int_t  fErrBPQnbins;

  void ResetBin(Int_t i);
  void DrawLegend();

  TPaveText *fFitLegend;
  Bool_t fFitOK;  
  
  BPFitFunc fgSinglePheFitFunc;     // In the beginning, 
  Int_t     fgSinglePheFitNPar;     // we want to be flexible using different functions

  Double_t  fLambda; 
  Double_t  fMu0; 
  Double_t  fMu1; 
  Double_t  fSigma0; 
  Double_t  fSigma1; 

  Double_t  fLambdaErr; 
  Double_t  fMu0Err; 
  Double_t  fMu1Err; 
  Double_t  fSigma0Err; 
  Double_t  fSigma1Err; 

  Double_t  fChisquare; 
  Double_t  fProb;      
  Int_t     fNdf;       

  Double_t  fMeanT; 
  Double_t  fMeanTErr; 
  Double_t  fSigmaT; 
  Double_t  fSigmaTErr; 
  
public:

  MHCalibrationBlindPixel(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationBlindPixel();

  Bool_t FillBPQ(Int_t q)         { return fHBPQ->Fill(q) > -1;  }  
  Bool_t FillErrBPQ(Float_t errq) { return fHBPErrQ->Fill(errq) > -1; }
  Bool_t FillBPT(Int_t t)         { return fHBPT->Fill(t) > -1;  }
  Bool_t FillBPQvsN(Stat_t rq, Int_t t) { return fHBPQvsN->Fill(t,rq) > -1;  }  
  
  const Double_t GetLambda()   const { return fLambda; }
  const Double_t GetMu0()     const { return fMu0; }
  const Double_t GetMu1()     const { return fMu1; }
  const Double_t GetSigma0()   const { return fSigma0; }
  const Double_t GetSigma1()   const { return fSigma1; }

  const Double_t GetLambdaErr() const { return fLambdaErr; }
  const Double_t GetMu0Err()   const { return fMu0Err; }
  const Double_t GetMu1Err()   const { return fMu1Err; }
  const Double_t GetSigma0Err() const { return fSigma0Err; }
  const Double_t GetSigma1Err() const { return fSigma1Err; }

  const Double_t GetChiSquare() const { return fChisquare; }
  const Double_t GetProb()    const { return fProb;      }  
  const Int_t    GetNdf()     const { return fNdf;       }   

  const Double_t GetMeanT()      const { return fMeanT; }
  const Double_t GetMeanTErr()    const { return fMeanTErr; }
  const Double_t GetSigmaT()      const { return fSigmaT; }
  const Double_t GetSigmaTErr()    const { return fSigmaTErr; }

  const TH1F *GetHErrQ() { return fHBPErrQ; }
  const TH1F *GetHErrQ() const { return fHBPErrQ; }
  
  Bool_t SimulateSinglePhe(Double_t lambda,
                           Double_t mu0,
                           Double_t mu1,
                           Double_t sigma0,
                           Double_t sigma1);
  
  Bool_t FitSinglePhe(Axis_t rmin=0, Axis_t rmax=0, Option_t *opt="R0+");
  Bool_t FitT(Axis_t rmin=0., Axis_t rmax=0.,Option_t *opt="R0+");

  void ChangeFitFunc(BPFitFunc fitfunc, Int_t par=5);


  void CutAllEdges();
  void Draw(Option_t *option="");

  ClassDef(MHCalibrationBlindPixel, 0) 
};

#endif  /* MARS_MHCalibrationBlindPixel */
