#ifndef MARS_MStereoCalc
#define MARS_MStereoCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MStereoCalc                                                             //
//                                                                         //
// Task to calculate some shower parameters in stereo mode                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MGeomCam;
class MHillas;
class MMcEvt;
class MStereoPar;

class MStereoCalc : public MTask
{
    const MGeomCam    *fGeomCam1;    //! Camera Geometry CT1
    const MHillas     *fHillas1;     //! input
    const MMcEvt      *fmcevt1;      //! input

    const MGeomCam    *fGeomCam2;    //! Camera Geometry CT2
    const MHillas     *fHillas2;     //! input
    const MMcEvt      *fmcevt2;      //! input

    Int_t fCT1_id;   //! 
    Int_t fCT2_id;   //! Identifiers of the two analyzed telescopes.

    Float_t fCT1_x;   //!
    Float_t fCT1_y;   //! Position of first telescope
    Float_t fCT2_x;   //!
    Float_t fCT2_y;   //! Position of second telescope

    MStereoPar   *fStereoPar;     //! output container to store result
    TString       fStereoParName; // name of the 'MStereoPar' container

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();


public:

    MStereoCalc(const char *name=NULL, const char *title=NULL);

    void SetNameStereoPar(const char *name) { fStereoParName = name; }

    void SetCTids(Int_t i, Int_t j) { fCT1_id = i; fCT2_id = j; }
    void SetCT1coor(Float_t x, Float_t y) { fCT1_x = x; fCT1_y = y; } // in m
    void SetCT2coor(Float_t x, Float_t y) { fCT2_x = x; fCT2_y = y; } // in m

    ClassDef(MStereoCalc, 0) // Task to calculate some shower parameters in stereo mode
};

#endif


