/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek  11/2003 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MFAntiFilter                                                          //
//                                                                         //
//   it checks the result of the filter 'fFilter' and returns the opposite //
//   of the result                                                         //
//                                                                         //
//   Note : when this class is used both the original filter and its       //
//          opposite are available; this is not the case when              //
//          SetInverted() is used;                                         //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MFAntiFilter.h"

#include <math.h>
#include <fstream>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

#include "MFilter.h"

ClassImp(MFAntiFilter);

using namespace std;

// --------------------------------------------------------------------------
//
MFAntiFilter::MFAntiFilter(MFilter &filter, 
                 const char *name, const char *title)
{
    fName  = name  ? name  : "MFAntiFilter";
    fTitle = title ? title : "Filter returning the opposite of a given filter";

    fFilter = &filter;
}


// --------------------------------------------------------------------------
//
Int_t MFAntiFilter::PreProcess(MParList *pList)
{
  fNumSelectedEvts = 0;

  return kTRUE;
}

// --------------------------------------------------------------------------
//
Int_t MFAntiFilter::Process()
{
  fResult = !fFilter->IsConditionTrue();

  if (!fResult)
    return kTRUE;

  fNumSelectedEvts++;

  return kTRUE;
}

// --------------------------------------------------------------------------
//
Int_t MFAntiFilter::PostProcess()
{
  *fLog << "MFAntiFilter::PostProcess; "   << fNumSelectedEvts 
        << " events were selected out of " << GetNumExecutions() << endl;

  return kTRUE;
}

//=========================================================================







