#ifndef MARS_MCalibrationCalc
#define MARS_MCalibrationCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationCalc                                                   //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;

class MPedestalCam;
class MCalibrationCam;

class MTime;

class MCalibrationCalc : public MTask
{
private:

  MPedestalCam             *fPedestals;    // Pedestals of all pixels in the camera
  MCalibrationCam          *fCalibrations; // Calibration events of all pixels in the camera

  MRawEvtData              *fRawEvt;       // raw event data (time slices)
  MRawRunHeader            *fRunHeader;    // RunHeader information

  MTime                    *fEvtTime;      // Time of the event

  Int_t fEvents;                           // Number of events  
  Int_t fHistOverFlow;                     // Number of events with saturated Low Gain
  Int_t fCosmics;                          // Number of events due to supposed cosmics

  Byte_t fNumHiGainSamples; 
  Byte_t fNumLoGainSamples; 

  Byte_t fFlags;                           // Flag for the fits used
   

  enum
    {
      kUseTFits = 1,
      kUseBPFit = 2,
      kUsePDFit = 3
    };

public:
  
  enum PulserColor_t  { kEGreen, kEBlue, kEUV };

private:

  PulserColor_t  fColor;
  
  Bool_t ReInit(MParList *pList); 
  Int_t PreProcess(MParList *pList);
  Int_t Process();
  Int_t PostProcess();
  
public:

  MCalibrationCalc(const char *name=NULL, const char *title=NULL);

  void SetSkipTFits(Bool_t b=kTRUE)
      {b ? CLRBIT(fFlags, kUseTFits) : SETBIT(fFlags, kUseTFits);}
  void SetSkipBPFit(Bool_t b=kTRUE)
      {b ? CLRBIT(fFlags, kUseBPFit) : SETBIT(fFlags, kUseBPFit);}
  void SetSkipPDFit(Bool_t b=kTRUE)
      {b ? CLRBIT(fFlags, kUsePDFit) : SETBIT(fFlags, kUsePDFit);}

  void SetPulserColor(PulserColor_t color)    { fColor = color; }
  
  ClassDef(MCalibrationCalc, 1)   // Task to fill the Calibration Containers from raw data
};

#endif
