#ifndef MGIMAGE_H
#define MGIMAGE_H

//
// This File contains the declaration of the MGImage-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#ifndef ROOT_TGX11
#include <TGX11.h>
#endif

class TMutex;

typedef unsigned char byte;

class MGImage : public TGFrame
{
    XImage *fImage;

    GContext_t fDefGC;
    Pixmap_t   fPixmap;

    UInt_t fWidth;
    UInt_t fHeight;

    TMutex *fMuxPixmap; //! test

    enum { kNeedRedraw = BIT(17) };

    void DrawImg16(unsigned short *d, char *s, char *e);
    void DrawImg24(char *d, char *s, char *e);
    void DrawColImg16(unsigned short *d, char *s1, char *s2, char *e);
    void DrawColImg24(char *d, char *s1, char *s2, char *e);

public:
    MGImage(const TGWindow* p, UInt_t w, UInt_t h, UInt_t options = kSunkenFrame, ULong_t back = fgDefaultFrameBackground);
    ~MGImage();

    void DoRedraw();

    void DrawImg(const byte *buffer);
    void DrawColImg(const byte *gbuf, const byte *cbuf);

    ClassDef(MGImage, 0)
};

#endif // MGIMAGE_H
