/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MTime
//
// A generalized MARS time stamp
//
//
// Version 1:
// ----------
//  - first version
//
// Version 2:
// ----------
//  - removed fTimeStamp[2]
//
/////////////////////////////////////////////////////////////////////////////
#include "MTime.h"

#include <iomanip>

#include <TTime.h>

#include "MLog.h"

ClassImp(MTime);

using namespace std;

void MTime::SetTime(const TTime &t)
{
    SetTime((ULong_t)t);
}

void MTime::Print(Option_t *) const
{
    *fLog << GetDescriptor() << ": " << dec << setfill('0');
    *fLog << setw(2) << (int)fHour << ":";
    *fLog << setw(2) << (int)fMin  << ":";
    *fLog << setw(2) << (int)fSec  << ".";
    *fLog << setw(9) << fNanoSec << endl;
} 
