#ifndef MARS_MFAntiFilter
#define MARS_MFAntiFilter

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFAntiFilter                                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MFilter;

class MFAntiFilter : public MFilter
{
private:

    Int_t   fNumSelectedEvts;
    MFilter *fFilter;

    Bool_t  fResult; //!

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MFAntiFilter(MFilter &filter,
                 const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    ClassDef(MFAntiFilter, 1) // A filter which returns the opposite of a given filter
};

#endif










