/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Sebastian Raducci, 12/2003 <mailto:raducci@fisica.uniud.it>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MArrivalTime
//
// P R E L I M I N A R Y
// Do not use this container. It has yet to be defined.
/////////////////////////////////////////////////////////////////////////////
#include "MArrivalTime.h"

#include "MGeomCam.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MRawEvtPixelIter.h"
#include "MRawEvtData.h"

ClassImp(MArrivalTime);

using namespace std;

// --------------------------------------------------------------------------
//
// Creates an object containing the arrival time for each pixel in the event
//
MArrivalTime::MArrivalTime(const char *name, const char *title)
{
    fName  = name  ? name  : "MArrivalTime";
    fTitle = title ? title : "Photons arrival times Information";
}

//
// Calculates the arrival time for each pixel (for now, simply by finding the peak)
//

void MArrivalTime::Calc(const MRawEvtData &evt, const MGeomCam &geom)
{
    const Int_t n = geom.GetNumPixels();

    fData.Set(n);
    fData.Reset();

    MRawEvtPixelIter pixel((MRawEvtData*)&evt);

    Int_t saturatedpixels = 0;

    while ( pixel.Next() )
    {
        const UInt_t idx = pixel.GetPixelId();

        Byte_t *ptr = pixel.GetHiGainSamples();

	Int_t n = evt.GetNumHiGainSamples();

        Int_t i;

        Double_t arrtime = 0;

	Double_t maxsign = 0;

        for (i=0; i<n; i++)
        {
            if (ptr[i]==0xff)
                break;
            if (ptr[i]>maxsign)
               { 
                maxsign = ptr[i];
	        arrtime = i+1;
               }
        }

	Bool_t saturatedlg = kFALSE;

        if (i!=n)
        {
	    arrtime = 0;
	    maxsign = 0;

            ptr = pixel.GetLoGainSamples();
            if (ptr==NULL)
            {
             *fLog << warn << "WARNING - Pixel #" << idx 
                   << " saturated but has no low gains... skipping!" << endl;
             return;
            }

            for (i=0; i<n; i++)
            {
                if (ptr[i]==0xff)
                    saturatedlg = kTRUE;

	    	if (ptr[i]>maxsign)
                   {
                    maxsign = ptr[i];
		    arrtime = i+1;
		   }
            }
        }

        fData[idx]=arrtime;

	if (saturatedlg)
	  saturatedpixels++;
    }

    if (saturatedpixels>0)
        *fLog << warn << "WARNING: " << saturatedpixels 
              << " pixel(s) had saturating low gains..." << endl;


}


// --------------------------------------------------------------------------
//
// Returns the arrival time value (for now, it's the FADC slice number).
//

Bool_t MArrivalTime::GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type) const
{
    if (idx<0 || idx>=fData.GetSize())
        return kFALSE;

    val = fData[idx];
    return kTRUE;
}

void MArrivalTime::DrawPixelContent(Int_t num) const
{
    *fLog << warn << "MArrivalTime::DrawPixelContent - not available." << endl;
}
