#ifndef MARS_MExtractedSignalCam
#define MARS_MExtractedSignalCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MExtractedSignalPix;

class MExtractedSignalCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

    Byte_t fNumUsedHiGainFADCSlices;
    Byte_t fNumUsedLoGainFADCSlices;

public:

    MExtractedSignalCam(const char *name=NULL, const char *title=NULL);
    ~MExtractedSignalCam();

    void Clear(Option_t *o="");

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    Byte_t GetNumUsedFADCSlices()          { return fNumUsedHiGainFADCSlices; }
    Byte_t GetNumUsedHiGainFADCSlices()    { return fNumUsedHiGainFADCSlices; }
    Byte_t GetNumUsedLoGainFADCSlices()    { return fNumUsedLoGainFADCSlices; }
    SetNumUsedHiGainFADCSlices(Byte_t numh, Byte_t numl)   
                                           { 
					     fNumUsedHiGainFADCSlices = numh;
					     fNumUsedLoGainFADCSlices = numl;  
					   }

    MExtractedSignalPix &operator[](Int_t i);
    MExtractedSignalPix &operator[](Int_t i) const;

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MExtractedSignalCam, 0)	// Storage Container for extracted signals in the camera
};

#endif

