#ifndef MARS_MPedPhotCam
#define MARS_MPedPhotCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedPhotPix;

class MPedPhotCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

public:
    MPedPhotCam(const char *name=NULL, const char *title=NULL);
    ~MPedPhotCam();

    void Clear(Option_t *o="");

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    MPedPhotPix &operator[](Int_t i);
    MPedPhotPix &operator[](Int_t i) const;

    //    Float_t GetPedestalMin(const MGeomCam *cam) const;
    //    Float_t GetPedestalMax(const MGeomCam *cam) const;

    //    Bool_t CheckBounds(Int_t i);

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MPedPhotCam, 1)	// Storage Container for all pedestal information of the camera (in units of photons)
};

#endif

