#ifndef MARS_MHCalibrationBlindPixel
#define MARS_MHCalibrationBlindPixel

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MHCalibrationConfig
#include "MHCalibrationConfig.h"
#endif

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1F
#include "TH1F.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

#ifndef ROOT_TPaveText
#include "TPaveText.h"
#endif

class TMath;
class MParList;
class MHCalibrationBlindPixel : public MH
{
private:

  TH1F* fHBlindPixelCharge;        //-> Histogram with the single Phe spectrum
  TH1F* fHBlindPixelErrCharge;     //-> Variance of summed FADC slices
  TH1I* fHBlindPixelTime;        //-> Variance of summed FADC slices
  TH1I* fHBlindPixelChargevsN;     //-> Summed Charge vs. Event Nr. 
  
  TF1 *fSinglePheFit;
  TF1 *fTimeGausFit;  

  Axis_t  fBlindPixelChargefirst;
  Axis_t  fBlindPixelChargelast;
  Int_t   fBlindPixelChargenbins;
  
  Axis_t fErrBlindPixelChargefirst;
  Axis_t fErrBlindPixelChargelast;
  Int_t  fErrBlindPixelChargenbins;

  void ResetBin(Int_t i);
  void DrawLegend();

  TPaveText *fFitLegend;
  Bool_t fFitOK;  
  
  BlindPixelFitFunc fgSinglePheFitFunc;     // In the beginning, 
  Int_t     fgSinglePheFitNPar;     // we want to be flexible using different functions

  Double_t  fLambda; 
  Double_t  fMu0; 
  Double_t  fMu1; 
  Double_t  fSigma0; 
  Double_t  fSigma1; 

  Double_t  fLambdaErr; 
  Double_t  fMu0Err; 
  Double_t  fMu1Err; 
  Double_t  fSigma0Err; 
  Double_t  fSigma1Err; 

  Double_t  fChisquare; 
  Double_t  fProb;      
  Int_t     fNdf;       

  Double_t  fMeanTime; 
  Double_t  fMeanTimeErr; 
  Double_t  fSigmaTime; 
  Double_t  fSigmaTimeErr; 
  
public:

  MHCalibrationBlindPixel(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationBlindPixel();

  Bool_t FillBlindPixelCharge(Float_t q)             { return fHBlindPixelCharge->Fill(q) > -1;  }  
  Bool_t FillErrBlindPixelCharge(Float_t errq)       { return fHBlindPixelErrCharge->Fill(errq) > -1; }
  Bool_t FillBlindPixelTime(Int_t t)                 { return fHBlindPixelTime->Fill(t) > -1;  }
  Bool_t FillBlindPixelChargevsN(Stat_t rq, Int_t t) { return fHBlindPixelChargevsN->Fill(t,rq) > -1;  }  
  
  const Double_t GetLambda()   const { return fLambda; }
  const Double_t GetMu0()     const { return fMu0; }
  const Double_t GetMu1()     const { return fMu1; }
  const Double_t GetSigma0()   const { return fSigma0; }
  const Double_t GetSigma1()   const { return fSigma1; }

  const Double_t GetLambdaErr() const { return fLambdaErr; }
  const Double_t GetMu0Err()   const { return fMu0Err; }
  const Double_t GetMu1Err()   const { return fMu1Err; }
  const Double_t GetSigma0Err() const { return fSigma0Err; }
  const Double_t GetSigma1Err() const { return fSigma1Err; }

  const Double_t GetChiSquare() const { return fChisquare; }
  const Double_t GetProb()    const { return fProb;      }  
  const Int_t    GetNdf()     const { return fNdf;       }   

  const Double_t GetMeanTime()      const { return fMeanTime; }
  const Double_t GetMeanTimeErr()    const { return fMeanTimeErr; }
  const Double_t GetSigmaTime()      const { return fSigmaTime; }
  const Double_t GetSigmaTimeErr()    const { return fSigmaTimeErr; }

  const TH1F *GetHErrCharge() { return fHBlindPixelErrCharge; }
  const TH1F *GetHErrCharge() const { return fHBlindPixelErrCharge; }
  
  Bool_t SimulateSinglePhe(Double_t lambda,
                           Double_t mu0,
                           Double_t mu1,
                           Double_t sigma0,
                           Double_t sigma1);
  
  Bool_t FitSinglePhe(Axis_t rmin=0, Axis_t rmax=0, Option_t *opt="R0+");
  Bool_t FitTime(Axis_t rmin=0., Axis_t rmax=0.,Option_t *opt="R0+");

  void ChangeFitFunc(BlindPixelFitFunc fitfunc, Int_t par=5);

  void CutAllEdges();
  void Draw(Option_t *option="");

  ClassDef(MHCalibrationBlindPixel, 1) 
};

#endif  /* MARS_MHCalibrationBlindPixel */
