/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationBlindPix                                                    //
//                                                                         //
// This is the storage container to hold informations about the calibration//
// blind pixel                                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationBlindPix.h"
#include "MHCalibrationBlindPixel.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MCalibrationBlindPix);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MCalibrationBlindPix::MCalibrationBlindPix(const char *name, const char *title)
    : fHist(NULL)
{

  fName  = name  ? name  : "MCalibrationBlindPix";
  fTitle = title ? title : "Container of the MHCalibrationBlindPixel and the fit results";

  fHist = new MHCalibrationBlindPixel();
  
  if (!fHist)
    *fLog << err << dbginf << "Could not create MHCalibrationBlindPixel " << endl;

  fLambda    = fMu0    = fMu1    = fSigma0    = fSigma1    = 0;
  fErrLambda = fErrMu0 = fErrMu1 = fErrSigma0 = fErrSigma1 = 0;
  
  fTime = fErrTime = 0;
}

MCalibrationBlindPix::~MCalibrationBlindPix() 
{
  delete fHist;
}

// ------------------------------------------------------------------------
//
// Invalidate values
//
void MCalibrationBlindPix::Clear(Option_t *o)
{
  fHist->Reset();
}

Bool_t MCalibrationBlindPix::FitCharge() 
{

  if (!fHist->FitSinglePhe())
    return kFALSE;
  
  fLambda = fHist->GetLambda();
  fMu0    = fHist->GetMu0();
  fMu1    = fHist->GetMu1();
  fSigma0 = fHist->GetSigma0();
  fSigma1 = fHist->GetSigma1();

  fErrLambda = fHist->GetLambdaErr();
  fErrMu0    = fHist->GetMu0Err();
  fErrMu1    = fHist->GetMu1Err();
  fErrSigma0 = fHist->GetSigma0Err();
  fErrSigma1 = fHist->GetSigma1Err();

  return kTRUE;
}



Bool_t MCalibrationBlindPix::FitTime() 
{

  if(!fHist->FitTime())
    return kFALSE;

  fTime    = fHist->GetMeanTime();
  fErrTime = fHist->GetMeanTimeErr();
  
  return kTRUE;

}
