#ifndef MARS_MExtractedSignalPix
#define MARS_MExtractedSignalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalPix : public MParContainer
{
private:

    Float_t fExtractedSignalHiGain;      // mean value of the extracted signal
    Float_t fExtractedSignalHiGainError; // error of the mean value of the extracted signal
    Float_t fExtractedSignalLoGain;      // mean value of the extracted signal
    Float_t fExtractedSignalLoGainError; // error of the mean value of the extracted signal
    Bool_t fIsLoGainUsed;
    Byte_t fNumHiGainSaturated;
    Byte_t fNumLoGainSaturated;

    Float_t fMeanArrivalTime;
    Float_t fWidthArrivalTime;

public:

    MExtractedSignalPix(const char* name=NULL, const char* title=NULL);

    void Clear(Option_t *o="");

    Float_t GetExtractedSignalHiGain()      const   { return fExtractedSignalHiGain; }
    Float_t GetExtractedSignalHiGainError() const   { return fExtractedSignalHiGainError; }

    Float_t GetExtractedSignalLoGain()      const   { return fExtractedSignalLoGain; }
    Float_t GetExtractedSignalLoGainError() const   { return fExtractedSignalLoGainError; }

    Float_t GetMeanArrivalTime()      const   { return fMeanArrivalTime; }
    Float_t GetWidthArrivalTime()     const   { return fWidthArrivalTime; }

    void SetExtractedSignal(Float_t sig, Float_t sigerr)   
                                        { 
					  fExtractedSignalHiGain = sig; 
					  fExtractedSignalHiGainError = sigerr; 
					}

    void SetExtractedSignal(Float_t sighi, Float_t sighierr,Float_t siglo, Float_t sigloerr)   
                                        { 
					  fExtractedSignalHiGain = sighi; 
					  fExtractedSignalHiGainError = sighierr; 
					  fExtractedSignalLoGain = siglo; 
					  fExtractedSignalLoGainError = sigloerr; 
					}

    void SetGainSaturation(Bool_t sat, Byte_t higain, Byte_t logain) 
                                        { fIsLoGainUsed = sat; 
					  fNumHiGainSaturated = higain;  
					  fNumLoGainSaturated = logain; }

    void SetArrivalTimes(Float_t mean, Float_t width) 
                                     { fMeanArrivalTime = mean;
                                       fWidthArrivalTime  = width;
				     }

    Bool_t IsLoGainUsed()               { return fIsLoGainUsed; }

    Bool_t IsValid() const              { return fExtractedSignalHiGain >= 0. || fExtractedSignalHiGainError >= 0.; }

    void PrintOut();

    ClassDef(MExtractedSignalPix, 0)	// Storage Container for Extracted Signal information of one pixel
};

#endif

