#ifndef MARS_MHEffOnTimeTime
#define MARS_MHEffOnTimeTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MTime;
class TH2D;
class MParList;

class MHEffOnTimeTime : public MH
{
private:
    TH1D fHEffOn;
    TH1D fHChi2;
    TH1D fHLambda;
    TH1D fHN0del;

public:
    MHEffOnTimeTime(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);

    const TH1D *GetHist() { return &fHEffOn; }
    const TH1D *GetHist() const { return &fHEffOn; }

    void Calc(TH2D *hist);

    void Draw(Option_t *option="");

    ClassDef(MHEffOnTimeTime, 0) //1D-plot of Delta t vs. time
};

#endif

