#ifndef SLALIB_H
#define SLALIB_H

#include <TROOT.h>

#include "coord.h"
#include "MTime.h"
#include "MObservatory.h"

class Slalib : public MObservatory
{
private:
    MTime fTime;

    double fAlpha;

    static Double_t Round(Double_t val);
    static Double_t Trunc(Double_t val);

public:
    Slalib(MObservatory::LocationName_t key);

    virtual void SetMjd(double mjd);
    Double_t GetMjd() const { return fTime.GetMjd(); }
    void Now() { fTime.Now(); }
    const MTime &GetTime() const { return fTime; }

    double GetAlpha() const  { return fAlpha; }

    ZdAz   XYZ2ZdAz(double coord[3]) const;

    ClassDef(Slalib, 0)
};

#endif
