#ifndef MARS_MMcCalibrationCalc
#define MARS_MMcCalibrationCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MCalibrationCam;
class MMcFadcHeader;
class MExtractedSignalCam;

class MMcCalibrationCalc : public MTask
{
private:
    Bool_t CheckRunType(MParList *pList) const;
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Bool_t ReInit(MParList *pList);

    MCalibrationCam     *fCalCam;
    MMcFadcHeader       *fHeaderFadc;
    MExtractedSignalCam *fSignalCam;

    Float_t fADC2PheInner;
    Float_t fADC2PheOuter;

public:
    MMcCalibrationCalc(const char *name=NULL, const char *title=NULL);

    void SetADC2PheInner(Float_t x) {fADC2PheInner = x; }
    void SetADC2PheOuter(Float_t x) {fADC2PheOuter = x; }

    ClassDef(MMcCalibrationCalc, 0)   // Task which obtains, for MC files, the pedestal mean and rms, and the calibration factor from ADC counts to photons. 
};

#endif
