/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 12/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MReportCC
//
// This is the class interpreting and storing the CC-REPORT information.
//
// From here maily weather station data is decoded such as
// temperature, humidity, wind-speed and solar radiation
//
//////////////////////////////////////////////////////////////////////////////
#include "MReportCC.h"

#include "MLogManip.h"

#include "MAstro.h"

ClassImp(MReportCC);

using namespace std;

MReportCC::MReportCC() : MReport("CC-REPORT")
{
    fName  = "MReportCC";
    fTitle = "Class for CC-REPORT information";
}

Bool_t MReportCC::InterpreteBody(TString &str)
{
    // Remove the 30 tokens of the subsystem status
    //  table 12.1 p59
    for (int i=0; i<30; i++)
        str.Remove(0, str.First(' ')+1);

    Int_t len;
    Float_t zd, az, dec, ra;
    const Int_t n=sscanf(str.Data(),
                         "%*f %*f %*f %*f %f %f %f %f %*f %*f %n",
                         &fTemperature, &fSolarRadiation, &fWindSpeed,
                         &fHumidity, &len);
    if (n!=4)
    {
        *fLog << err << "ERROR - Wrong number of arguments." << endl;
        return kFALSE;
    }
    str.Remove(0, len);

    if (str!=(TString)"OVER")
    {
        *fLog << err << "ERROR - Termination (OVER) too far away." << endl;
        return kFALSE;
    }

    return kTRUE;
}
