#ifndef MARS_MReportFileRead
#define MARS_MReportFileRead

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif

/*// gcc 3.2
//class ifstream;
#include <iosfwd>
*/

class THashTable;

class MTime;
class MReport;
class MReportHelp;

class MReportFileRead : public MTask
{
private:
    static const TString gsReportHeader;
    static const TString gsVersionPrefix;

    TString     fFileName;
    ifstream   *fIn;         //! buffered input stream (file to read from)

    THashTable *fList;

    MTime fStart;            // Time range which should be read from file
    MTime fStop;             // Time range which should be read from file

    enum { kHasNoHeader = BIT(14) };

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t CheckFileHeader() const;
    MReport *GetReport(const TString &str) const;
    MReport *GetReport(MReportHelp *help) const;
    MReportHelp *GetReportHelp(const TString &str) const;

public:
    MReportFileRead(const char *filename, const char *name=NULL, const char *title=NULL);
    ~MReportFileRead();

    void SetHasNoHeader() { SetBit(kHasNoHeader); }
    void SetTimeStart(const MTime &tm) { fStart = tm; }
    void SetTimeStop(const MTime &tm)  { fStop = tm; }

    Bool_t AddToList(const char *name) const;

    ClassDef(MReportFileRead, 0)// Task to read the central control report file
};

#endif
