/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Sabrina Stark  12/2003 <mailto:lstark@particle.phys.ethz.ch>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedestalWorkaround                                                     //
//                                                                         //
// This class contains the function to store the pedestal value and the    //
//  RMS of the pedestal in units of photons.                               //  
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MPedestalWorkaround.h"

#include <stdio.h>
#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"
#include "MGeomCam.h"

#include "MPedestalCam.h"
#include "MPedestalPix.h"
#include "MPedPhotCam.h"

using namespace std;

ClassImp(MPedestalWorkaround);

MPedestalWorkaround::MPedestalWorkaround(const char *name, const char *title)
{
    fName = name ? name : "MPedestalWorkaround";
    fTitle = title ? title : "Storage of pedestal values and RMS in units of photons";
   
}

// ------------------------------------------------------------------------
//

Int_t MPedestalWorkaround::PreProcess(MParList *pList)
{
   fPed = (MPedestalCam*)pList->FindObject("MPedestalCam");
   if (!fPed)
     {
       *fLog << err << "MPedestalCam not found... aborting." << endl;
       return kFALSE;
     }
   fPedPhot = (MPedPhotCam*)pList->FindObject("MPedPhotCam");
   if (!fPedPhot)
     {
       *fLog << err << "MPedPhotCam not found... aborting." << endl;
       return kFALSE;
     }
   fCam = (MGeomCam*)pList->FindObject("MGeomCam");
   if (!fCam)
     {
       *fLog << err << "MGeomCam not found (no geometry information available)... aborting." << endl;
       return kFALSE;
     }

    return kTRUE;
}

// ------------------------------------------------------------------------
//
Int_t MPedestalWorkaround::Process()
{
   
 UInt_t imaxnumpix = fCam->GetNumPixels();

  for (UInt_t i=0; i<imaxnumpix; i++)
  {
    Int_t type = 0;
    Double_t val;
    Float_t valout;
    fPedPhot->GetPixelContent( val, i, *fCam, type);
    valout = (*fPed)[i].GetPedestal();
    (*fPed)[i].SetPedestal(val);
    *fLog << "i, val, valout : " << i <<",  "<<  val<<",  " << valout << endl;
    type = 1;
    fPedPhot->GetPixelContent( val, i, *fCam, type);
    valout = (*fPed)[i].GetPedestalRms();
    (*fPed)[i].SetPedestalRms(val);
    *fLog << "RMS : i, val, valout : " << i <<",  "<<  val<<",  " << valout << endl;
  }


    return kTRUE;
}

Int_t MPedestalWorkaround::PostProcess()
{
    return kTRUE;
}

