#ifndef MARS_MFGeomag
#define MARS_MFGeomag

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFGeomag                                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MMcEvt;
class MParList;

class MFGeomag : public MFilter
{
private:
    MMcEvt *fMcEvt;
    TString fContName;

    typedef enum { kEEqual, kENotEqual } FilterType_t;
    FilterType_t fFilterType;

    Bool_t fResult;    //!
    Bool_t fGamm_elec;  // switches gammas to electrons
    //
    Float_t fRigMin[2*1152];    //tables to contain cut limits
    Float_t fRigMax[2*1152];
    Float_t fProb  [2*1152];

    void Init(const char type, const Int_t val,
              const char *name, const char *title);


    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MFGeomag(const char *cname="MMcEvt", const char type='=', const Int_t val=0,
                 const char *name=NULL, const char *title=NULL);

    void  SetGammElec();    // allows to use gammas like electrons
    Bool_t IsExpressionTrue() const {return fResult;};

    ClassDef(MFGeomag,0) // Filter for MC particles, by geomagnetic field
};

#endif
