#ifndef MARS_MHSigmaTheta
#define MARS_MHSigmaTheta

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

#ifndef ROOT_TH3
#include <TH3.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MPedestalCam;
class MMcEvt;
class MPedestalCam;
class MSigmabar;
class MParList;


class MHSigmaTheta : public MH
{
private:
    const MGeomCam *fCam;        //!
    MPedestalCam   *fPed;        //!
    MCerPhotEvt    *fEvt;        //!
    MSigmabar      *fSigmabar;   //!
    MMcEvt         *fMcEvt;      //!
 
    TH2D fSigmaTheta;    // 2D-distribution sigmabar versus Theta; 
                         // sigmabar is the average pedestasl sigma in an event
    TH3D fSigmaPixTheta; // 3D-distr.:Theta, pixel, pedestal sigma
    TH3D fDiffPixTheta;  // 3D-distr.:Theta, pixel, sigma^2-sigmabar^2

    void Paint(Option_t *opt="");

public:
    MHSigmaTheta(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    const TH2D *GetSigmaTheta() { return &fSigmaTheta; }
    const TH2D *GetSigmaTheta() const { return &fSigmaTheta; }

    const TH3D *GetSigmaPixTheta() { return &fSigmaPixTheta; }
    const TH3D *GetSigmaPixTheta() const { return &fSigmaPixTheta; }

    const TH3D *GetDiffPixTheta() { return &fDiffPixTheta; }
    const TH3D *GetDiffPixTheta() const { return &fDiffPixTheta; }

    void Draw(Option_t *option="");

    ClassDef(MHSigmaTheta, 1) //2D-histogram  sigmabar vs. Theta
};

#endif





