#ifndef MARS_MPointingPos
#define MARS_MPointingPos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPointingPos : public MParContainer
{
private:
    Double_t fZd;  // [deg] Zenith distance (ZA)
    Double_t fAz;  // [deg] Azimuth

    Double_t fRa;  // [deg] Right ascension
    Double_t fHa;  // [deg] Houre angle
    Double_t fDec; // [deg] Declination

public:
    MPointingPos()
    {
        fName  = "MPointingPos";
        fTitle = "Container storing the (corrected) telescope pointing position";
    }

    void SetLocalPosition(Double_t zd, Double_t az) { fZd=zd; fAz=az; }
    void SetSkyPosition(Double_t ra, Double_t dec, Double_t ha=0) { fRa=ra; fDec=dec; fHa=ha; }

    Double_t GetZd() const { return fZd; }
    Double_t GetAz() const { return fAz; }

    ClassDef(MPointingPos, 1) //Container storing the (corrected) telescope pointing position
};

#endif
