#ifndef MARS_MExtractedSignalCam
#define MARS_MExtractedSignalCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;
class MExtractedSignalPix;

class MExtractedSignalCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

    // FIXME: Is it necessary to store this information for each event?
    Byte_t fNumUsedHiGainFADCSlices;
    Byte_t fNumUsedLoGainFADCSlices;

    Byte_t fFirstUsedSliceHiGain;
    Byte_t fFirstUsedSliceLoGain;

    Byte_t fLastUsedSliceHiGain;
    Byte_t fLastUsedSliceLoGain;

public:

    MExtractedSignalCam(const char *name=NULL, const char *title=NULL);
    ~MExtractedSignalCam();

    void Clear(Option_t *o="");

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    Byte_t GetNumUsedFADCSlices()          { return fNumUsedHiGainFADCSlices; }
    Byte_t GetNumUsedHiGainFADCSlices()    { return fNumUsedHiGainFADCSlices; }
    Byte_t GetNumUsedLoGainFADCSlices()    { return fNumUsedLoGainFADCSlices; }

    Byte_t GetFirstUsedSliceHiGain()       { return fFirstUsedSliceHiGain; }
    Byte_t GetLastUsedSliceHiGain()        { return fLastUsedSliceHiGain; }

    Byte_t GetFirstUsedSliceLoGain()       { return fFirstUsedSliceLoGain; }
    Byte_t GetLastUsedSliceLoGain()        { return fLastUsedSliceLoGain; }

    void   SetNumUsedFADCSlices(Byte_t numh, Byte_t firsth, Byte_t lasth, 
                                Byte_t numl, Byte_t firstl, Byte_t lastl)
    {
        // FIXME: Calculate the number of used slices from first/last
        //        to make sure, that the stored values are always
        //        consistent!
        fNumUsedHiGainFADCSlices = numh;
        fFirstUsedSliceHiGain    = firsth;
        fLastUsedSliceHiGain     = lasth;
        fNumUsedLoGainFADCSlices = numl;
        fFirstUsedSliceLoGain    = firstl;
        fLastUsedSliceLoGain     = lastl;
    }

    MExtractedSignalPix &operator[](Int_t i);
    MExtractedSignalPix &operator[](Int_t i) const;

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MExtractedSignalCam, 0)	// Storage Container for extracted signals in the camera
};

#endif

