#ifndef MARS_MRawEvtData
#define MARS_MRawEvtData

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MRawRunHeader;
class MRawCrateArray;

class TArrayC;
class MArrayS;
class MArrayB;

class MRawEvtData : public MCamEvent
{
    friend class MRawEvtPixelIter;
private:
    MRawRunHeader  *fRunHeader;   //! provides information about numbers
    MRawCrateArray *fCrateArray;  //! provides information about ab flag

    // FIXME: COMMENT ABOUT ORDERING

    MArrayS *fHiGainPixId;        //-> list of pixel IDs of hi gain channel
    MArrayB *fHiGainFadcSamples;  //-> list of hi gain samples of all pixels (ordering: see fHiGainPixId)

    MArrayS *fLoGainPixId;        //-> list of pixel IDs of lo gain channel
    MArrayB *fLoGainFadcSamples;  //-> list of lo gain samples of all pixels (ordering: see fLoGainPixId)

    TArrayC *fABFlags;            //-> A information about the exact trigger position

    Int_t fPosInArray;        //!
    Int_t fConnectedPixels;   //!
    Int_t fArraySize;         //!

    void InitArrays(Bool_t flag=kFALSE);
    void DeleteArrays();

public:
    MRawEvtData(const char *name=NULL, const char *title=NULL);
    ~MRawEvtData();

    void Init(MRawRunHeader *rh, MRawCrateArray *arr)
    {
        //
        // you have to set this before you can read information
        // from a magic binary file
        //
        fRunHeader  = rh;
        fCrateArray = arr;
    }

    void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;
    void Draw (Option_t * = NULL);

    void DeletePixels(Bool_t flag=kFALSE);
    void ResetPixels() { DeletePixels(kTRUE); }
    void AddPixel(UShort_t nOfPixel, TArrayC *data, Bool_t lflag=kFALSE);

    Byte_t   GetNumHiGainSamples() const;
    Byte_t   GetNumLoGainSamples() const;
    UShort_t GetNumPixels() const;

    void ReadEvt(istream &fin);

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void   DrawPixelContent(Int_t num) const
    {
        TString s("HIST");
        s += num;
        const_cast<MRawEvtData*>(this)->Draw(s);
    }

    void Copy(TObject &named)
#if ROOT_VERSION_CODE > ROOT_VERSION(3,04,01)
        const
#endif
        ;

    ClassDef(MRawEvtData, 3) //Container to store the raw Event Data
};

#endif
