#ifndef MARS_MCameraData
#define MARS_MCameraData

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif
#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MGeomCam;
class MSigmabar;
class MCerPhotEvt;
class MPedPhotCam;

class MCameraData : public MCamEvent
{
private:
    TArrayD fData;  //
    TArrayC fValidity;

public:
    MCameraData(const char *name=NULL, const char *title=NULL);
    ~MCameraData() { }

    UInt_t GetNumPixels() const { return fData.GetSize(); }

    void CalcCleaningLevel(const MCerPhotEvt &evt, const MPedPhotCam &fCam,
                           const MGeomCam &geom);
    void CalcCleaningLevel(const MCerPhotEvt &evt, const MSigmabar &sgb,
                           const MGeomCam &geom);
    void CalcCleaningLevel(const MCerPhotEvt &evt, Double_t noise,
                           const MGeomCam &geom);
/*
    void Calc(const MCerPhotEvt &evt, const MGeomCam &geom)
    {
        CalcCleaningLevel(evt, 1, geom);
    }
 */
    const TArrayD &GetData() const { return fData; }
    const TArrayC &GetValidity() const  { return fValidity; }

    Double_t operator[](int i) { return fData[i]; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MCameraData, 2)    // class for an event containing cerenkov photons
};

#endif
