#ifndef MARS_MPedestalPix
#define MARS_MPedestalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MHPedestalPixel
#include "MHPedestalPixel.h"
#endif

class MHPedestalPixel;
class MPedestalPix : public MParContainer
{
private:
    Float_t fPedestal;     // mean value of pedestal (PMT offset)
    Float_t fPedestalRms;  // root mean square / sigma  / standard deviation of pedestal

    MHPedestalPixel *fHist; // Pointer to the histograms performing the fits, etc.      

    Float_t fMean;
    Float_t fMeanErr;
    Float_t fSigma;
    Float_t fSigmaErr;
    Float_t fProb;

    Byte_t fFlags;

    enum   { kFitted, kFitValid  };
    
public:
    MPedestalPix();
    ~MPedestalPix();
    
    void Clear(Option_t *o="");

    // Using histograms
    void InitUseHists();
    void FillHists(const Float_t f);
    
    // Setters
    void SetPedestal(const Float_t f)    { fPedestal = f; }
    void SetPedestalRms(const Float_t f) { fPedestalRms = f; }

    void Set(const Float_t m, const Float_t r);

    // Getters
    Float_t GetPedestal()    const { return fPedestal; }
    Float_t GetPedestalRms() const { return fPedestalRms; }

    Float_t GetMean()        const { return fMean;     }
    Float_t GetMeanErr()     const { return fMeanErr;  }
    Float_t GetSigma()       const { return fSigma;    }
    Float_t GetSigmaErr()    const { return fSigmaErr; }
    Float_t GetProb()        const { return fProb;     }
    
    Bool_t IsValid()         const;
    Bool_t IsFitted()        const;
    Bool_t IsFitValid()      const;    
    
    // Fits
    void FitCharge();   
    Bool_t CheckFitValidity();
    
    // Draws
    void Draw(Option_t *opt="")                 { fHist->Draw(opt); }
    TObject *DrawClone(Option_t *opt="") const { return fHist->DrawClone(opt); }  

    ClassDef(MPedestalPix, 1)	// Storage Container for Pedestal information of one pixel
};

#endif

