//
//     class MTrigger
//
//     implemented by Harald Kornmayer
//
//     This is a class to simulate the trigger. 
//     It assumes a special response of the PMT for one single Photo-electron. 
//     
//
//
#include <iostream.h>
#include <math.h> 

#include "TObject.h"

#include "Mdefine.h" 

#define TRIGGER_TIME_SLICES    400
//
//      We need 400 Time Slices of 0.25 nsec width. 
//      So the whole Time range we studies is 100 nsec. 
//
#define RESPONSE_SLICES        40
//
//       This is for the standard response Signal to 1 Photoelectron
//       that leaves the Photocathode
//       The whole Timescale for the signal is 10 nsec
//
//
//       These values are discussed with Eckart. We start from this point. 
#define RESPONSE_FWHM          2. 
#define RESPONSE_AMPLITUDE     1. 
//
//       This are the Standard values of the response function for
//       1 photo electron. 
//       We assume a gaussian pulse with FWHM 2.5 nsec. 
//

#define CHANNEL_THRESHOLD      2. 
//
//       This is the diskriminator threshold for each individual channel
//       First we set the value to 2 unit of the RESPONSE_AMPLITUDE 
//
#define TRIGGER_GATE           3. 
// 
//       Here we set the width of the digital signal we get if the signal
//       passes the diskriminator
//
#define TRIGGER_MULTI          4.  
//
//       We get a Level Zero Trigger, if we have a least TRIGGER_MULTI
//       channels with a diskrimiator signal at the same time 
//

